/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.util.network;

import java.util.Map;
import okhttp3.MediaType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.core.permission.Permission;
import top.focess.qq.core.permission.PermissionEnv;
import top.focess.util.network.HttpHandler;
import top.focess.util.network.HttpResponse;
import top.focess.util.network.NetworkHandler;

@PermissionEnv(values={Permission.NETWORK})
public class NetworkHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkHandler.class);
    public static final @NonNull MediaType JSON = top.focess.util.network.NetworkHandler.JSON;
    public static final @NonNull MediaType TEXT = top.focess.util.network.NetworkHandler.TEXT;
    public static final @NonNull MediaType URL_ENCODED = top.focess.util.network.NetworkHandler.URL_ENCODED;
    private final Plugin plugin;
    private final top.focess.util.network.NetworkHandler networkHandler;

    public NetworkHandler(final Plugin plugin, NetworkHandler.Options options) {
        Permission.checkPermission(Permission.NETWORK);
        this.plugin = plugin;
        this.networkHandler = new top.focess.util.network.NetworkHandler(options);
        this.networkHandler.addHandler(new HttpHandler(){

            public void handle(String url, String data, Map<String, String> header, String body) {
                LOGGER.debug("[FocessQQ][Network] -> [" + plugin.getName() + "] " + url + " Request: " + data + " with Header: " + header + ", Response: " + body);
            }

            public void handleException(String url, String data, Map<String, String> header, Exception e) {
                LOGGER.debug("[FocessQQ][Network] -> [" + plugin.getName() + "] " + url + " Request: " + data + " with Header: " + header + ", Error: " + e.getMessage());
            }
        });
    }

    public NetworkHandler(Plugin plugin) {
        this(plugin, NetworkHandler.Options.ofNull());
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public HttpResponse request(String url, Map<String, Object> data, NetworkHandler.RequestType requestType) {
        return this.networkHandler.request(url, data, requestType);
    }

    public HttpResponse request(String url, NetworkHandler.RequestType requestType) {
        return this.networkHandler.request(url, requestType);
    }

    public HttpResponse request(String url, Map<String, Object> data, Map<String, String> header, MediaType mediaType, NetworkHandler.RequestType requestType) {
        return this.networkHandler.request(url, data, header, mediaType, requestType);
    }

    public HttpResponse request(String url, String data, Map<String, String> header, MediaType mediaType, NetworkHandler.RequestType requestType) {
        return this.networkHandler.request(url, data, header, mediaType, requestType);
    }

    public HttpResponse put(String url, String data, Map<String, String> header, @NotNull MediaType mediaType) {
        return this.networkHandler.put(url, data, header, mediaType);
    }

    public HttpResponse post(String url, String data, Map<String, String> header, @NotNull MediaType mediaType) {
        return this.networkHandler.post(url, data, header, mediaType);
    }

    public HttpResponse delete(String url, String data, Map<String, String> header, @NotNull MediaType mediaType) {
        return this.networkHandler.delete(url, data, header, mediaType);
    }

    public HttpResponse get(String url, @NotNull Map<String, Object> data, Map<String, String> header) {
        return this.networkHandler.get(url, data, header);
    }
}

