/*
 * Decompiled with CFR 0.152.
 */
package io.github.gexingw.spring.transaction.message.infrastructure.repository;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.github.gexingw.spring.transaction.message.domain.message.MessageStatus;
import io.github.gexingw.spring.transaction.message.domain.message.TransactionMessage;
import io.github.gexingw.spring.transaction.message.domain.message.TransactionMessageRepository;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;

public class JdbcTransactionMessageRepositoryImpl
implements TransactionMessageRepository {
    private final JdbcOperations jdbcOperations;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public JdbcTransactionMessageRepositoryImpl(JdbcOperations jdbcOperations) {
        this.jdbcOperations = jdbcOperations;
    }

    @Override
    public List<TransactionMessage> queryAllRetryable(long currentTimestamp) {
        String querySql = "select * from transaction_message where next_retry_time <= ? and message_status = ?";
        Object[] args = new Object[]{currentTimestamp, MessageStatus.NORMAL.toString()};
        int[] argTypes = new int[]{4, 1};
        return this.jdbcOperations.query(querySql, args, argTypes, (RowMapper)new TransactionMessageRowMapper());
    }

    @Override
    public void save(TransactionMessage message) {
        if (message.getId() == null) {
            this.create(message);
            return;
        }
        this.update(message);
    }

    private void create(TransactionMessage message) {
        long id = System.currentTimeMillis();
        String sql = "INSERT INTO transaction_message (id, topic, `key`, max_retry_count, next_retry_time, payload, message_status) VALUES (?, ?, ?, ?, ?, ?, ?)";
        String payloadJsonStr = this.toJsonString(message.getPayload());
        Object[] args = new Object[]{id, message.getTopic(), message.getKey(), message.getMaxRetryCount(), message.getNextRetryTime(), payloadJsonStr, message.getMessageStatus().toString()};
        if (this.jdbcOperations.update(sql, args) <= 0) {
            throw new RuntimeException("\u4fdd\u5b58\u4e8b\u52a1\u6d88\u606f\u5931\u8d25");
        }
        message.setId(id);
    }

    private void update(TransactionMessage message) {
        String sql = "UPDATE transaction_message set retried_count = ?, next_retry_time = ?, message_status = ? WHERE id = ?";
        Object[] args = new Object[]{message.getRetriedCount(), message.getNextRetryTime(), message.getMessageStatus().toString(), message.getId()};
        if (this.jdbcOperations.update(sql, args) <= 0) {
            throw new RuntimeException("\u4fdd\u5b58\u4e8b\u52a1\u6d88\u606f\u5931\u8d25");
        }
    }

    @Override
    public void remove(Serializable id) {
        if (this.jdbcOperations.update("DELETE FROM transaction_message WHERE id = ?", new Object[]{id}) <= 0) {
            throw new RuntimeException("\u5220\u9664\u4e8b\u52a1\u6d88\u606f\u5931\u8d25");
        }
    }

    @Override
    public TransactionMessage find(Serializable id) {
        Object[] args = new Object[]{id};
        String query = "SELECT * FROM transaction_message WHERE id = ?";
        int[] argTypes = new int[]{-5};
        List queryResult = this.jdbcOperations.query(query, args, argTypes, (RowMapper)new TransactionMessageRowMapper());
        return !queryResult.isEmpty() ? (TransactionMessage)queryResult.get(0) : null;
    }

    private String toJsonString(Object data) {
        try {
            return OBJECT_MAPPER.writeValueAsString(data);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
    }

    public static class TransactionMessageRowMapper
    implements RowMapper<TransactionMessage> {
        public TransactionMessage mapRow(ResultSet rs, int rowNum) throws SQLException {
            return new TransactionMessage(rs.getLong("id"), rs.getString("topic"), rs.getString("key"), rs.getInt("max_retry_count"), rs.getInt("retried_count"), rs.getLong("next_retry_time"), rs.getObject("payload"), MessageStatus.valueOf(rs.getString("message_status")));
        }
    }
}

