/*
 * Decompiled with CFR 0.152.
 */
package io.github.gexingw.spring.transaction.message.service.impl;

import io.github.gexingw.spring.transaction.message.domain.message.TransactionMessage;
import io.github.gexingw.spring.transaction.message.domain.message.TransactionMessageRepository;
import io.github.gexingw.spring.transaction.message.infrastructure.util.TransactionUtil;
import io.github.gexingw.spring.transaction.message.service.TransactionMessageService;
import java.io.Serializable;
import java.time.Instant;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

public class JdbcTransactionMessageServiceImpl
implements TransactionMessageService {
    private final TransactionMessageRepository transactionMessageRepository;

    public JdbcTransactionMessageServiceImpl(TransactionMessageRepository transactionMessageRepository) {
        this.transactionMessageRepository = transactionMessageRepository;
    }

    @Override
    public List<TransactionMessage> queryRetryableMessages() {
        return this.queryRetryableMessages(Instant.now().getEpochSecond());
    }

    @Override
    public List<TransactionMessage> queryRetryableMessages(long currentTimestamp) {
        return this.transactionMessageRepository.queryAllRetryable(currentTimestamp);
    }

    @Override
    public void sendSucceed(Serializable id) {
        this.transactionMessageRepository.remove(id);
    }

    @Override
    public void sendFailed(Serializable id) {
        TransactionMessage transactionMessage = this.transactionMessageRepository.find(id);
        transactionMessage.sendFailed();
        this.transactionMessageRepository.save(transactionMessage);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void send(TransactionMessage transactionMessage, Runnable sendCallback) {
        this.transactionMessageRepository.save(transactionMessage);
        TransactionUtil.doAfterCommitted(sendCallback);
    }
}

