package top.goodz.commons.core.context;

import cn.hutool.core.convert.Convert;
import com.alibaba.ttl.TransmittableThreadLocal;
import top.goodz.commons.core.constant.SecurityConstants;
import top.goodz.commons.core.constant.UserConstants;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 线程上线文信息
 */
public class ThreadContextUtil {
    private ThreadContextUtil() {
    }

    private static final ThreadLocal<Map<String, String>> THREAD_LOCAL = new TransmittableThreadLocal<>();

    public static Long getUserId() {
        Long userId = get(UserConstants.CONTEXT_USER_ID, Long.class);
        return userId;
    }

    public static void setUserId(Long userId) {
        set(UserConstants.CONTEXT_USER_ID, userId);
    }

    public static void setUserName(String userName) {
        set(UserConstants.CONTEXT_USER_NAME, userName);
    }

    public static String getUserName() {
        return get(UserConstants.CONTEXT_USER_NAME, String.class);
    }

    public static void setAuthorization(String authorization) {
        set(SecurityConstants.CONTEXT_AUTHORIZATION, authorization);
    }

    public static String getAuthorization() {
        return get(SecurityConstants.CONTEXT_AUTHORIZATION, String.class);
    }

    public static Boolean isAdmin(Long userId){
        return UserConstants.ADMIN_ID.equals(userId);
    }

    public static void remove() {
        THREAD_LOCAL.remove();
    }

    private static void set(String key, Object value) {
        Map<String, String> map = getLocalMap();
        map.put(key, value == null ? "" : value.toString());
    }

    private static <T> T get(String key, Class<T> type) {
        Map<String, String> map = getLocalMap();
        return Convert.convert(type, map.get(key));
    }

    private static Map<String, String> getLocalMap() {
        Map<String, String> map = THREAD_LOCAL.get();
        if (map == null) {
            map = new ConcurrentHashMap<>(10);
            THREAD_LOCAL.set(map);
        }
        return map;
    }

}
