package top.goodz.commons.core.domain;

import top.goodz.commons.core.constant.Constants;
import top.goodz.commons.core.exception.ServiceException;
import top.goodz.commons.core.utils.DateUtils;
import top.goodz.commons.core.utils.HttpUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 响应信息主体
 *
 * @author future
 */
@Data
@NoArgsConstructor
@ApiModel("请求响应对象")
public class R<T> implements Serializable {
    private static final long serialVersionUID = 1L;

    public static final String SUCCESS_MESSAGE = "操作成功";
    public static final String DEFAULT_ERROR_MESSAGE = "系统繁忙，请稍候再试";
    public static final String TIMEOUT_ERROR_MESSAGE = "请求超时，请稍候再试";

    /**
     * 默认异常消息
     */
    public static final String DETAULT_ERROR_MSG = "网络异常，请稍后重试!";

    /**
     * 成功
     */
    public static final int SUCCESS = Constants.SUCCESS;

    /**
     * 失败
     */
    public static final int FAIL = Constants.FAIL;

    @ApiModelProperty("状态码 200-处理成功")
    private int code;

    @ApiModelProperty("消息")
    private String msg;

    @ApiModelProperty("数据")
    private T data;

    @ApiModelProperty(value = "响应时间戳")
    private String timestamp = DateUtils.getDateTimeMill();

    @ApiModelProperty(value = "请求路径")
    private String url = HttpUtils.getRequestUrl();

    //默认只显示前5行异常堆栈，每行逗号分隔
    @ApiModelProperty("异常堆栈")
    private String stackTrace;

    public static <T> R<T> ok() {
        return restResult(null, SUCCESS, SUCCESS_MESSAGE);
    }

    public static <T> R<T> ok(T data) {
        return restResult(data, SUCCESS, SUCCESS_MESSAGE);
    }

    public static <T> R<T> fail() {
        return restResult(null, FAIL, DEFAULT_ERROR_MESSAGE);
    }

    public static <T> R<T> fail(String msg) {
        return restResult(null, FAIL, msg);
    }

    public static <T> R<T> fail(String msg, String stackTrace) {
        R<T> r = restResult(null, FAIL, msg);
        r.setStackTrace(stackTrace);
        return r;
    }

    public static <T> R<T> fail(int code, String msg) {
        return restResult(null, code, msg);
    }

    private static <T> R<T> restResult(T data, int code, String msg) {
        R<T> r = new R<>();
        r.setCode(code);
        r.setData(data);
        r.setMsg(msg);
        return r;
    }

    public static <T> T getData(R<T> r){
        if(FAIL == r.getCode()){
            throw new ServiceException(r.getMsg());
        }
        return r.getData();
    }
}
