package top.goodz.commons.core.enums;

import com.baomidou.mybatisplus.annotation.IEnum;

import java.io.Serializable;
import java.util.stream.Stream;


public interface BaseEnum<T extends Serializable> extends IEnum<T> {

    /**
     * 描述
     */
    String getDesc();

    /**
     * 从value获取枚举
     */
    /*static BaseIntEnum of(Integer val) {
            return Stream.of(values()).parallel().filter(item -> item.value.equals(val)).findAny().orElse(null);
      }*/

    /**
     * value是否跟当前枚举值相等
     */
    default boolean eq(T val) {
        return val != null && this.getValue().equals(val);
    }

}
