package top.goodz.commons.core.listener;

import top.goodz.commons.core.domain.OperLogDTO;
import top.goodz.commons.core.event.OperLogEvent;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;

import java.util.function.Consumer;

@Slf4j
@AllArgsConstructor
public class OperLogListener {

    private final Consumer<OperLogDTO> consumer;

    //@Async //此处异步会导致上下文信息无法传递到下游
    @Order
    @EventListener
    public void saveOperLogDTO(OperLogEvent event) {
        OperLogDTO sysLog = (OperLogDTO) event.getSource();

        if (sysLog == null) {
            return;
        }

        consumer.accept(sysLog);
    }

}
