package top.goodz.commons.core.service;

import top.goodz.commons.core.exception.ServiceException;
import lombok.Data;

@Data
public class RemoteServiceHolder {
    public static RemoteDictService remoteDictService;

    public static void setDictService(RemoteDictService remoteDictService) {
        RemoteServiceHolder.remoteDictService = remoteDictService;
    }

    public static RemoteDictService getDictService() {
        if (remoteDictService == null) {
            throw new ServiceException("请实现RemoteDictService接口，并注入Spring容器");
        }
        return remoteDictService;
    }

    public static RemoteLogService remoteLogService;

    public static void setLogService(RemoteLogService remoteLogService) {
        RemoteServiceHolder.remoteLogService = remoteLogService;
    }

    public static RemoteLogService getLogService() {
        if (remoteLogService == null) {
            throw new ServiceException("请实现RemoteLogService接口，并注入Spring容器");
        }
        return remoteLogService;
    }

    public static RemoteUserService remoteUserService;

    public static void setUserService(RemoteUserService remoteUserService) {
        RemoteServiceHolder.remoteUserService = remoteUserService;
    }

    public static RemoteUserService getUserService() {
        if (remoteUserService == null) {
            throw new ServiceException("请实现RemoteUserService接口，并注入Spring容器");
        }
        return remoteUserService;
    }

    public static RemoteDataScopeService remoteDataScopeService;

    public static void setDataScopeService(RemoteDataScopeService remoteDataScopeService) {
        RemoteServiceHolder.remoteDataScopeService = remoteDataScopeService;
    }

    public static RemoteDataScopeService getDataScopeService() {
        if (remoteDataScopeService == null) {
            throw new ServiceException("请实现RemoteDataScopeService接口，并注入Spring容器");
        }
        return remoteDataScopeService;
    }
}
