package top.goodz.commons.core.utils;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.ArrayUtil;

import java.util.Arrays;

public class ExceptionUtils extends ExceptionUtil {
    /**
     * 获取异常信息
     *
     * @param throwable
     * @param limitLines
     * @param join
     * @return
     */
    public static String getStacktrace(Throwable throwable, Integer limitLines, String join) {
        if (throwable == null) {
            return "";
        }
        String res = throwable.toString();
        if (ArrayUtil.isNotEmpty(throwable.getStackTrace())) {
            res += (join + StringUtils.join(Arrays.copyOfRange(throwable.getStackTrace(), 0, limitLines), join));
        }
        return res;
    }
}
