package top.goodz.commons.core.utils;

import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * 执行异步方法
 */
public class ExecutorUtil {

    //核心线程数
    private static final int CORE_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 2 + 1;
    //队列容量
    private static final int QUEUE_CAPACITY = 1024;
    //活跃时间
    private static final int KEEP_ALIVE_SECONDS = 300;
    private static ThreadPoolTaskExecutor executor;

    static {
        executor = new ThreadPoolTaskExecutor();
        //核心线程数
        executor.setCorePoolSize(CORE_POOL_SIZE);
        //最大线程数
        executor.setMaxPoolSize(CORE_POOL_SIZE);
        //队列容量
        executor.setQueueCapacity(QUEUE_CAPACITY);
        //活跃时间
        executor.setKeepAliveSeconds(KEEP_ALIVE_SECONDS);
        //线程名字前缀
        executor.setThreadNamePrefix("future-executor-");

        // setRejectedExecutionHandler：当pool已经达到max size的时候，如何处理新任务
        // CallerRunsPolicy：不在新线程中执行任务，而是由调用者所在的线程来执行
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
    }

    public static void execute(Runnable runnable) {
        executor.execute(runnable);
    }

    public static Future<?> submit(Runnable task) {
        return executor.submit(task);
    }

    public static <T> Future<T> submit(Callable<T> task) {
        return executor.submit(task);
    }

}
