package top.goodz.commons.core.utils;

import top.goodz.commons.core.config.AsyncConfig;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
 * 执行异步方法
 */
@Component
public class ExecutorUtils implements ApplicationContextAware {

    private static ThreadPoolTaskExecutor executor;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        executor = applicationContext.getBean(AsyncConfig.DEFAULT_EXECUTOR_NAME, ThreadPoolTaskExecutor.class);
    }

    public static void execute(Runnable runnable) {
        executor.execute(runnable);
    }

    public static Future<?> submit(Runnable task) {
        return executor.submit(task);
    }

    public static <T> Future<T> submit(Callable<T> task) {
        return executor.submit(task);
    }

}
