package top.goodz.commons.core.utils;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.http.HttpUtil;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.io.BufferedInputStream;
import java.io.OutputStream;
import java.util.Optional;

@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class HttpUtils extends HttpUtil {

    /**
     * 当前请求url
     */
    public static String getRequestUrl() {
        String url = StringUtils.EMPTY;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            HttpServletRequest request = ((ServletRequestAttributes) requestAttributes).getRequest();
            url = Optional.ofNullable(request.getRequestURL()).map(u -> u.toString()).orElse(url);
        }
        return url;
    }

    /**
     * 从本地路径下载文件
     * @param filePath
     * @param out
     * @return
     */
    public static long downloadFilePath(String filePath, OutputStream out) {
        BufferedInputStream inputStream = FileUtil.getInputStream(filePath);
        long length = IoUtil.copy(inputStream, out);
        return length;
    }
}
