package top.goodz.commons.core.utils;

import cn.hutool.core.collection.ListUtil;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.google.common.collect.Maps;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ListUtils extends ListUtil {
    public static <T, R> Map<R, T> toMap(List<T> list, Function<T, R> function) {
        if (CollectionUtils.isNotEmpty(list)) {
            return list.stream().collect(Collectors.toMap(function, Function.identity(), (a, b) -> a));
        }
        return Maps.newHashMap();
    }
}
