/*
 * Decompiled with CFR 0.152.
 */
package top.goodz.commons.core.config;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import top.goodz.commons.core.enums.BaseEnum;
import top.goodz.commons.core.jackson.BaseEnumSerializer;
import top.goodz.commons.core.jackson.BigNumberSerializer;

@Configuration
@ConditionalOnClass(value={ObjectMapper.class})
@AutoConfigureBefore(value={JacksonAutoConfiguration.class})
public class JacksonConfig {
    private static final Logger log = LoggerFactory.getLogger(JacksonConfig.class);

    @Primary
    @Bean
    public ObjectMapper getObjectMapper(Jackson2ObjectMapperBuilder builder, JacksonProperties jacksonProperties) {
        ObjectMapper objectMapper = builder.createXmlMapper(false).build();
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Long.class, (JsonSerializer)BigNumberSerializer.INSTANCE);
        simpleModule.addSerializer(Long.TYPE, (JsonSerializer)BigNumberSerializer.INSTANCE);
        simpleModule.addSerializer(BigInteger.class, (JsonSerializer)BigNumberSerializer.INSTANCE);
        simpleModule.addSerializer(BigDecimal.class, (JsonSerializer)ToStringSerializer.instance);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(jacksonProperties.getDateFormat() != null ? jacksonProperties.getDateFormat() : "yyyy-MM-dd HH:mm:ss");
        simpleModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(formatter));
        simpleModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(formatter));
        simpleModule.addSerializer(BaseEnum.class, (JsonSerializer)new BaseEnumSerializer());
        objectMapper.registerModule((Module)simpleModule);
        objectMapper.setTimeZone(TimeZone.getDefault());
        log.info("\u521d\u59cb\u5316 jackson \u914d\u7f6e");
        return objectMapper;
    }
}

