/*
 * Decompiled with CFR 0.152.
 */
package top.goodz.commons.core.context;

import cn.hutool.core.convert.Convert;
import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import top.goodz.commons.core.constant.UserConstants;

public class ThreadContextUtil {
    private static final ThreadLocal<Map<String, String>> THREAD_LOCAL = new TransmittableThreadLocal();

    private ThreadContextUtil() {
    }

    public static Long getUserId() {
        Long userId = ThreadContextUtil.get("user_id", Long.class);
        return userId;
    }

    public static void setUserId(Long userId) {
        ThreadContextUtil.set("user_id", userId);
    }

    public static void setUserName(String userName) {
        ThreadContextUtil.set("user_name", userName);
    }

    public static String getUserName() {
        return ThreadContextUtil.get("user_name", String.class);
    }

    public static void setAuthorization(String authorization) {
        ThreadContextUtil.set("Authorization", authorization);
    }

    public static String getAuthorization() {
        return ThreadContextUtil.get("Authorization", String.class);
    }

    public static Boolean isAdmin(Long userId) {
        return UserConstants.ADMIN_ID.equals(userId);
    }

    public static void remove() {
        THREAD_LOCAL.remove();
    }

    private static void set(String key, Object value) {
        Map<String, String> map = ThreadContextUtil.getLocalMap();
        map.put(key, value == null ? "" : value.toString());
    }

    private static <T> T get(String key, Class<T> type) {
        Map<String, String> map = ThreadContextUtil.getLocalMap();
        return (T)Convert.convert(type, (Object)map.get(key));
    }

    private static Map<String, String> getLocalMap() {
        Map<String, String> map = THREAD_LOCAL.get();
        if (map == null) {
            map = new ConcurrentHashMap<String, String>(10);
            THREAD_LOCAL.set(map);
        }
        return map;
    }
}

