/*
 * Decompiled with CFR 0.152.
 */
package top.goodz.commons.core.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import top.goodz.commons.core.constant.Constants;
import top.goodz.commons.core.exception.ServiceException;
import top.goodz.commons.core.utils.DateUtils;
import top.goodz.commons.core.utils.HttpUtils;

@ApiModel(value="\u8bf7\u6c42\u54cd\u5e94\u5bf9\u8c61")
public class R<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SUCCESS_MESSAGE = "\u64cd\u4f5c\u6210\u529f";
    public static final String DEFAULT_ERROR_MESSAGE = "\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5";
    public static final String TIMEOUT_ERROR_MESSAGE = "\u8bf7\u6c42\u8d85\u65f6\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5";
    public static final String DETAULT_ERROR_MSG = "\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!";
    public static final int SUCCESS = Constants.SUCCESS;
    public static final int FAIL = Constants.FAIL;
    @ApiModelProperty(value="\u72b6\u6001\u7801 200-\u5904\u7406\u6210\u529f")
    private int code;
    @ApiModelProperty(value="\u6d88\u606f")
    private String msg;
    @ApiModelProperty(value="\u6570\u636e")
    private T data;
    @ApiModelProperty(value="\u54cd\u5e94\u65f6\u95f4\u6233")
    private String timestamp = DateUtils.getDateTimeMill();
    @ApiModelProperty(value="\u8bf7\u6c42\u8def\u5f84")
    private String url = HttpUtils.getRequestUrl();
    @ApiModelProperty(value="\u5f02\u5e38\u5806\u6808")
    private String stackTrace;

    public static <T> R<T> ok() {
        return R.restResult(null, SUCCESS, SUCCESS_MESSAGE);
    }

    public static <T> R<T> ok(T data) {
        return R.restResult(data, SUCCESS, SUCCESS_MESSAGE);
    }

    public static <T> R<T> fail() {
        return R.restResult(null, FAIL, DEFAULT_ERROR_MESSAGE);
    }

    public static <T> R<T> fail(String msg) {
        return R.restResult(null, FAIL, msg);
    }

    public static <T> R<T> fail(String msg, String stackTrace) {
        R<Object> r = R.restResult(null, FAIL, msg);
        r.setStackTrace(stackTrace);
        return r;
    }

    public static <T> R<T> fail(int code, String msg) {
        return R.restResult(null, code, msg);
    }

    private static <T> R<T> restResult(T data, int code, String msg) {
        R<T> r = new R<T>();
        r.setCode(code);
        r.setData(data);
        r.setMsg(msg);
        return r;
    }

    public static <T> T getData(R<T> r) {
        if (FAIL == r.getCode()) {
            throw new ServiceException(r.getMsg());
        }
        return r.getData();
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getUrl() {
        return this.url;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof R)) {
            return false;
        }
        R other = (R)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$stackTrace = this.getStackTrace();
        String other$stackTrace = other.getStackTrace();
        return !(this$stackTrace == null ? other$stackTrace != null : !this$stackTrace.equals(other$stackTrace));
    }

    protected boolean canEqual(Object other) {
        return other instanceof R;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $stackTrace = this.getStackTrace();
        result = result * 59 + ($stackTrace == null ? 43 : $stackTrace.hashCode());
        return result;
    }

    public String toString() {
        return "R(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ", timestamp=" + this.getTimestamp() + ", url=" + this.getUrl() + ", stackTrace=" + this.getStackTrace() + ")";
    }
}

