/*
 * Decompiled with CFR 0.152.
 */
package top.goodz.commons.core.jackson;

import cn.hutool.core.util.ObjectUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import top.goodz.commons.core.annotation.Sensitive;
import top.goodz.commons.core.enums.SensitiveStrategy;
import top.goodz.commons.core.service.SensitiveService;
import top.goodz.commons.core.utils.SpringUtils;

public class SensitiveJsonSerializer
extends JsonSerializer<String>
implements ContextualSerializer {
    private static final Logger log = LoggerFactory.getLogger(SensitiveJsonSerializer.class);
    private SensitiveStrategy strategy;

    public void serialize(String value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        try {
            SensitiveService sensitiveService = (SensitiveService)SpringUtils.getBean(SensitiveService.class);
            if (ObjectUtil.isNotNull((Object)sensitiveService) && sensitiveService.isSensitive()) {
                gen.writeString(this.strategy.desensitizer().apply(value));
            } else {
                gen.writeString(value);
            }
        }
        catch (BeansException e) {
            log.error("\u8131\u654f\u5b9e\u73b0\u4e0d\u5b58\u5728, \u91c7\u7528\u9ed8\u8ba4\u5904\u7406 => {}", (Object)e.getMessage());
            gen.writeString(value);
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        Sensitive annotation = (Sensitive)property.getAnnotation(Sensitive.class);
        if (Objects.nonNull(annotation) && Objects.equals(String.class, property.getType().getRawClass())) {
            this.strategy = annotation.strategy();
            return this;
        }
        return prov.findValueSerializer(property.getType(), property);
    }
}

