/*
 * Decompiled with CFR 0.152.
 */
package top.goodz.commons.core.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.SimpleCache;
import cn.hutool.core.lang.func.Func0;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.cglib.core.Converter;

public class BeanCopyUtils {
    public static <T, V> V copy(T source, Class<V> desc) {
        if (ObjectUtil.isNull(source)) {
            return null;
        }
        if (ObjectUtil.isNull(desc)) {
            return null;
        }
        Object target = ReflectUtil.newInstanceIfPossible(desc);
        return (V)BeanCopyUtils.copy(source, target);
    }

    public static <T, V> V copy(T source, V desc) {
        if (ObjectUtil.isNull(source)) {
            return null;
        }
        if (ObjectUtil.isNull(desc)) {
            return null;
        }
        BeanCopier beanCopier = BeanCopierCache.INSTANCE.get(source.getClass(), desc.getClass(), null);
        beanCopier.copy(source, desc, null);
        return desc;
    }

    public static <T, V> List<V> copyList(List<T> sourceList, Class<V> desc) {
        if (ObjectUtil.isNull(sourceList)) {
            return null;
        }
        if (CollUtil.isEmpty(sourceList)) {
            return CollUtil.newArrayList((Object[])new Object[0]);
        }
        return sourceList.stream().map(source -> {
            Object target = ReflectUtil.newInstanceIfPossible((Class)desc);
            BeanCopyUtils.copy(source, target);
            return target;
        }).collect(Collectors.toList());
    }

    public static <T> Map<String, Object> copyToMap(T bean) {
        if (ObjectUtil.isNull(bean)) {
            return null;
        }
        return BeanMap.create(bean);
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<T> beanClass) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        if (ObjectUtil.isNull(beanClass)) {
            return null;
        }
        Object bean = ReflectUtil.newInstanceIfPossible(beanClass);
        return (T)BeanCopyUtils.mapToBean(map, bean);
    }

    public static <T> T mapToBean(Map<String, Object> map, T bean) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        if (ObjectUtil.isNull(bean)) {
            return null;
        }
        BeanMap.create(bean).putAll(map);
        return bean;
    }

    private BeanCopyUtils() {
    }

    public static enum BeanCopierCache {
        INSTANCE;

        private final SimpleCache<String, BeanCopier> cache = new SimpleCache();

        public BeanCopier get(Class<?> srcClass, Class<?> targetClass, Converter converter) {
            String key = this.genKey(srcClass, targetClass, converter);
            return (BeanCopier)this.cache.get((Object)key, (Func0 & Serializable)() -> BeanCopier.create((Class)srcClass, (Class)targetClass, (converter != null ? 1 : 0) != 0));
        }

        private String genKey(Class<?> srcClass, Class<?> targetClass, Converter converter) {
            StringBuilder key = StrUtil.builder().append(srcClass.getName()).append('#').append(targetClass.getName());
            if (null != converter) {
                key.append('#').append(converter.getClass().getName());
            }
            return key.toString();
        }
    }
}

