/*
 * Decompiled with CFR 0.152.
 */
package top.goodz.commons.core.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class ExecutorUtils
implements ApplicationContextAware {
    private static ThreadPoolTaskExecutor executor;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        executor = (ThreadPoolTaskExecutor)applicationContext.getBean("futureExecutorService", ThreadPoolTaskExecutor.class);
    }

    public static void execute(Runnable runnable) {
        executor.execute(runnable);
    }

    public static Future<?> submit(Runnable task) {
        return executor.submit(task);
    }

    public static <T> Future<T> submit(Callable<T> task) {
        return executor.submit(task);
    }
}

