/*
 * Decompiled with CFR 0.152.
 */
package top.goodz.commons.core.utils.ip;

import cn.hutool.core.lang.Dict;
import cn.hutool.core.net.NetUtil;
import cn.hutool.http.HtmlUtil;
import cn.hutool.http.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.goodz.commons.core.utils.JsonUtils;
import top.goodz.commons.core.utils.StringUtils;

public class AddressUtils {
    private static final Logger log = LoggerFactory.getLogger(AddressUtils.class);
    public static final String IP_URL = "http://whois.pconline.com.cn/ipJson.jsp";
    public static final String UNKNOWN = "XX XX";

    public static String getRealAddressByIP(String ip) {
        String address = UNKNOWN;
        if (StringUtils.isBlank((CharSequence)ip)) {
            return address;
        }
        String string = ip = "0:0:0:0:0:0:0:1".equals(ip) ? "127.0.0.1" : HtmlUtil.cleanHtmlTag((String)ip);
        if (NetUtil.isInnerIP((String)ip)) {
            return "\u5185\u7f51IP";
        }
        try {
            String rspStr = HttpUtil.createGet((String)IP_URL).body("ip=" + ip + "&json=true", "GBK").execute().body();
            if (StringUtils.isEmpty(rspStr)) {
                log.error("\u83b7\u53d6\u5730\u7406\u4f4d\u7f6e\u5f02\u5e38 {}", (Object)ip);
                return UNKNOWN;
            }
            Dict obj = JsonUtils.parseMap(rspStr);
            String region = obj.getStr("pro");
            String city = obj.getStr("city");
            return String.format("%s %s", region, city);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5730\u7406\u4f4d\u7f6e\u5f02\u5e38 {}", (Object)ip);
            return address;
        }
    }

    private AddressUtils() {
    }
}

