/*
 * Decompiled with CFR 0.152.
 */
package top.hequehua.swagger.config;

import com.jfinal.config.Routes;
import com.jfinal.core.ActionKey;
import com.jfinal.core.Controller;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.IPlugin;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import top.hequehua.swagger.annotation.Api;
import top.hequehua.swagger.annotation.ApiModel;
import top.hequehua.swagger.annotation.ApiOperation;
import top.hequehua.swagger.annotation.ApiParam;
import top.hequehua.swagger.annotation.ApiParams;
import top.hequehua.swagger.annotation.ApiRequests;
import top.hequehua.swagger.annotation.ApiResponse;
import top.hequehua.swagger.annotation.ApiResponses;
import top.hequehua.swagger.config.RequestMethod;
import top.hequehua.swagger.config.SwaggerConstant;
import top.hequehua.swagger.model.SwaggerApiInfo;
import top.hequehua.swagger.model.SwaggerApiMethod;
import top.hequehua.swagger.model.SwaggerDoc;
import top.hequehua.swagger.model.SwaggerDto;
import top.hequehua.swagger.model.SwaggerDtoProperties;
import top.hequehua.swagger.model.SwaggerParameter;
import top.hequehua.swagger.model.SwaggerResponse;
import top.hequehua.swagger.model.SwaggerSchema;

public class SwaggerPlugin
implements IPlugin {
    private static ConcurrentMap<String, SwaggerDoc> swaggerDocMap;
    private static List<SwaggerApiInfo> apiInfoList;
    private static Map<String, SwaggerDto> definitions;
    private static boolean ENABLE;

    public SwaggerPlugin(boolean enable) {
        ENABLE = enable;
        if (ENABLE) {
            swaggerDocMap = new ConcurrentHashMap<String, SwaggerDoc>();
            apiInfoList = new ArrayList<SwaggerApiInfo>();
            definitions = new LinkedHashMap<String, SwaggerDto>();
        }
    }

    public static boolean isEnable() {
        return ENABLE;
    }

    public static List<SwaggerApiInfo> getApiInfo() {
        return apiInfoList;
    }

    public SwaggerPlugin addSwaggerDoc(SwaggerDoc doc) {
        if (ENABLE) {
            swaggerDocMap.put(doc.getbasePackage(), doc);
            apiInfoList.add(doc.getInfo());
        }
        return this;
    }

    public static SwaggerDoc getDoc(String basePackage) {
        SwaggerDoc swaggerDoc;
        if (StrKit.isBlank((String)basePackage)) {
            basePackage = (String)swaggerDocMap.keySet().iterator().next();
        }
        if ((swaggerDoc = (SwaggerDoc)swaggerDocMap.get(basePackage)) != null) {
            swaggerDoc.setDefinitions(definitions);
        }
        return swaggerDoc;
    }

    public boolean start() {
        if (swaggerDocMap.isEmpty()) {
            throw new RuntimeException("The swagger start fail , SwaggerDoc can not be null");
        }
        List<Routes.Route> routeList = this.getAllRouteList();
        Set<String> excludedMethod = this.buildExcludedMethodName();
        for (Routes.Route aRouteList : routeList) {
            Method[] methods;
            Api api;
            Routes.Route route = aRouteList;
            Class cls = route.getControllerClass();
            if (!cls.isAnnotationPresent(Api.class) || (api = cls.getAnnotation(Api.class)).hidden()) continue;
            for (Method method : methods = cls.getDeclaredMethods()) {
                SwaggerDoc doc;
                ApiOperation apiOperation;
                if (excludedMethod.contains(method.getName()) || (apiOperation = this.getApiOperation(method)).hidden()) continue;
                SwaggerApiMethod apiMethod = this.getApiMethod(method, apiOperation, cls);
                String clsName = null;
                for (String key : swaggerDocMap.keySet()) {
                    if (!cls.getName().startsWith(key)) continue;
                    clsName = key;
                }
                if (StrKit.isBlank(clsName) || (doc = (SwaggerDoc)swaggerDocMap.get(clsName)) == null) continue;
                Map<String, Map<String, SwaggerApiMethod>> paths = doc.getPaths();
                Map<String, SwaggerApiMethod> methodMap = this.initMethodMap(method, apiMethod);
                String actionUrl = this.getActionUrl(route, method, apiOperation);
                paths.put(actionUrl, methodMap);
            }
            this.addApiTags(cls, api);
        }
        return true;
    }

    private String getApiMethodDefaultTag(Class<? extends Controller> cls, Api api) {
        return this.getDefaultTag(cls, api);
    }

    private List<Routes.Route> getAllRouteList() {
        List routesList = Routes.getRoutesList();
        ArrayList<Routes.Route> routeList = new ArrayList<Routes.Route>();
        for (Routes routes : routesList) {
            routeList.addAll(routes.getRouteItemList());
        }
        return routeList;
    }

    private ApiOperation getApiOperation(Method method) {
        ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
        if (apiOperation == null) {
            apiOperation = SwaggerConstant.defaultApiOperation;
        }
        return apiOperation;
    }

    private void addApiTags(Class<? extends Controller> cls, Api api) {
        String apiDescription = api.description();
        if (apiDescription.length() == 0) {
            apiDescription = api.tags().length == 1 ? api.tags()[0] : cls.getSimpleName() + " ";
        }
        String clsName = null;
        for (String key : swaggerDocMap.keySet()) {
            if (!cls.getName().startsWith(key)) continue;
            clsName = key;
        }
        if (StrKit.isBlank(clsName)) {
            return;
        }
        for (String tagName : api.tags()) {
            SwaggerPlugin.getDoc(clsName).addTag(tagName, apiDescription);
        }
        if (api.tags().length == 0) {
            SwaggerPlugin.getDoc(clsName).addTag(cls.getSimpleName(), apiDescription);
        }
    }

    private String getDefaultTag(Class<? extends Controller> cls, Api api) {
        String defaultApiMethodTag = api.value();
        if (StrKit.isBlank((String)defaultApiMethodTag)) {
            defaultApiMethodTag = cls.getSimpleName();
        }
        return defaultApiMethodTag;
    }

    private String getActionUrl(Routes.Route route, Method method, ApiOperation apiOperation) {
        if (StrKit.notBlank((String)apiOperation.value())) {
            return apiOperation.value();
        }
        ActionKey actionKey = method.getAnnotation(ActionKey.class);
        if (actionKey != null) {
            return actionKey.value();
        }
        return route.getControllerKey() + "/" + method.getName();
    }

    private SwaggerApiMethod getApiMethod(Method method, ApiOperation apiOperation, Class<? extends Controller> cls) {
        SwaggerApiMethod apiMethod = this.getApiMethodAndParms(method);
        apiMethod.setProduces(apiOperation.produces());
        apiMethod.setTags(apiOperation.tags());
        apiMethod.setSummary(apiOperation.summary());
        apiMethod.setDescription(apiOperation.description());
        apiMethod.setConsumes(apiOperation.consumes());
        Api api = cls.getAnnotation(Api.class);
        if (api == null) {
            return apiMethod;
        }
        if (apiMethod.getTags() == null || apiMethod.getTags().length == 0) {
            apiMethod.setTags(new String[]{this.getApiMethodDefaultTag(cls, api)});
        }
        return apiMethod;
    }

    private void initResponseParams(Method method, SwaggerApiMethod apiMethod) {
        ApiResponses[] apiResponses = (ApiResponses[])method.getAnnotationsByType(ApiResponses.class);
        if (apiResponses == null) {
            return;
        }
        HashMap<String, SwaggerResponse> responses = new HashMap<String, SwaggerResponse>();
        for (ApiResponses apiRespons : apiResponses) {
            ApiResponse[] params;
            for (ApiResponse param : params = apiRespons.value()) {
                responses.put(param.code(), new SwaggerResponse(param.message(), new SwaggerSchema("#/definitions/" + param.response().getSimpleName())));
                apiMethod.setResponses(responses);
                this.addResponseParams(param.response());
            }
        }
    }

    private SwaggerApiMethod getApiMethodAndParms(Method method) {
        SwaggerApiMethod apiMethod = new SwaggerApiMethod();
        this.initRequestParams(method, apiMethod);
        this.initResponseParams(method, apiMethod);
        return apiMethod;
    }

    private void addResponseParams(Class<?> cls) {
        Field[] fields;
        ApiModel apiModel = cls.getAnnotation(ApiModel.class);
        String description = apiModel == null || StrKit.isBlank((String)apiModel.description()) ? cls.getSimpleName() : apiModel.description();
        SwaggerDto swaggerDto = new SwaggerDto();
        swaggerDto.setTitle(cls.getSimpleName());
        swaggerDto.setType(SwaggerPlugin.getEnd(cls.getTypeName()));
        swaggerDto.setDescription(description);
        LinkedHashMap<String, SwaggerDtoProperties> swaggerDtoPropertiesMap = new LinkedHashMap<String, SwaggerDtoProperties>();
        for (Field f : fields = cls.getDeclaredFields()) {
            if (!f.isAnnotationPresent(ApiParam.class)) continue;
            ApiParam apiParam = f.getAnnotation(ApiParam.class);
            SwaggerDtoProperties dtoProperties = new SwaggerDtoProperties();
            dtoProperties.setDescription(apiParam.description());
            dtoProperties.setType(SwaggerPlugin.getEnd(f.getGenericType().getTypeName()));
            dtoProperties.setExample(apiParam.defaultValue());
            swaggerDtoPropertiesMap.put(f.getName(), dtoProperties);
        }
        swaggerDto.setProperties(swaggerDtoPropertiesMap);
        definitions.put(cls.getSimpleName(), swaggerDto);
    }

    private void initRequestParams(Method method, SwaggerApiMethod apiMethod) {
        ApiRequests[] apiRequests;
        ApiParams[] apiParamsArr = (ApiParams[])method.getAnnotationsByType(ApiParams.class);
        if (apiParamsArr != null && apiParamsArr.length != 0) {
            for (ApiParams apiParams : apiParamsArr) {
                ApiParam[] params;
                for (ApiParam apiParam : params = apiParams.value()) {
                    SwaggerParameter para = "File".toLowerCase().equals(apiParam.dataType().toLowerCase()) ? this.getFilePara(apiParam) : this.getPara(apiParam);
                    apiMethod.addParameter(para);
                }
            }
        }
        if ((apiRequests = (ApiRequests[])method.getAnnotationsByType(ApiRequests.class)) != null && apiRequests.length != 0) {
            for (ApiRequests apiRequest : apiRequests) {
                Field[] fields;
                Class<?> classObj = apiRequest.request();
                for (Field f : fields = classObj.getDeclaredFields()) {
                    if (!f.isAnnotationPresent(ApiParam.class)) continue;
                    ApiParam apiParam = f.getAnnotation(ApiParam.class);
                    SwaggerParameter swaggerParameter = new SwaggerParameter(f.getName(), apiParam.description(), apiParam.required(), SwaggerPlugin.getEnd(f.getGenericType().getTypeName()), apiParam.defaultValue(), SwaggerPlugin.getEnd(f.getGenericType().getTypeName()));
                    apiMethod.addParameter(swaggerParameter);
                }
            }
        }
    }

    private Set<String> buildExcludedMethodName() {
        Method[] methods;
        HashSet<String> excludedMethodName = new HashSet<String>();
        for (Method m : methods = Controller.class.getMethods()) {
            excludedMethodName.add(m.getName());
        }
        return excludedMethodName;
    }

    private SwaggerParameter getFilePara(ApiParam apiParam) {
        return new SwaggerParameter(apiParam.name(), "formData", apiParam.description(), apiParam.required(), apiParam.dataType(), apiParam.defaultValue(), apiParam.paramType());
    }

    private SwaggerParameter getPara(ApiParam apiParam) {
        return new SwaggerParameter(apiParam.name(), apiParam.description(), apiParam.required(), apiParam.dataType(), apiParam.defaultValue(), apiParam.paramType());
    }

    private Map<String, SwaggerApiMethod> initMethodMap(Method method, SwaggerApiMethod apiMethod) {
        ApiOperation apiOperation = this.getApiOperation(method);
        RequestMethod[] requestMethods = apiOperation.methods();
        if (requestMethods.length == 0) {
            requestMethods = RequestMethod.all();
        }
        return this.getMethodMap(requestMethods, apiMethod, method.getName());
    }

    private Map<String, SwaggerApiMethod> getMethodMap(RequestMethod[] methods, SwaggerApiMethod apiMethod, String methodName) {
        HashMap<String, SwaggerApiMethod> methodMap = new HashMap<String, SwaggerApiMethod>();
        SwaggerApiMethod putApiMethod = null;
        for (RequestMethod requestMethod : methods) {
            try {
                putApiMethod = (SwaggerApiMethod)apiMethod.clone();
                putApiMethod.setOperationId(methodName.concat("Using").concat(requestMethod.toString()));
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            methodMap.put(requestMethod.toString(), putApiMethod);
        }
        return methodMap;
    }

    private static String getEnd(String str) {
        String[] a = str.split("\\.");
        return a[a.length - 1];
    }

    public boolean stop() {
        return true;
    }
}

