/*
 * Decompiled with CFR 0.152.
 */
package top.hequehua.swagger.handler;

import com.jfinal.handler.Handler;
import com.jfinal.kit.LogKit;
import com.jfinal.kit.StrKit;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import top.hequehua.swagger.utils.StringUtil;

public class WebJarsHandler
extends Handler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, boolean[] isHandled) {
        String path = null;
        if (target.contains("doc.html")) {
            path = "doc.html";
        } else if (target.startsWith("/webjars/")) {
            path = "webjars/" + StringUtil.substringAfter(target, "/webjars/");
        } else if (target.startsWith("/WebJars/")) {
            path = "WebJars/" + StringUtil.substringAfter(target, "/WebJars/");
        }
        if (StrKit.notBlank((String)path)) {
            InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(path);
            ServletOutputStream outputStream = null;
            try {
                if (inputStream != null) {
                    outputStream = response.getOutputStream();
                    IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
                }
            }
            catch (IOException e) {
                LogKit.error((String)("cant get static resource : " + path + " from jar"), (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
            isHandled[0] = true;
        }
        this.next.handle(target, request, response, isHandled);
    }
}

