/*
 * Decompiled with CFR 0.152.
 */
package top.hmtools;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import top.hmtools.beans.DivisionBean;
import top.hmtools.dictionary.Dictionary;
import top.hmtools.enums.EDataVersion;

public class GBT2260 {
    private static String luceneTmpFilePath = "./GBT2260/";

    public static void init() {
        Dictionary.init();
        List<DivisionBean> list = Dictionary.getAll();
        try {
            GBT2260.addToLucene(list.toArray(new DivisionBean[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void init(String luceneTmpPath, String dataFilePath) {
        try {
            GBT2260.init(luceneTmpPath, new FileInputStream(dataFilePath));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void init(String luceneTmpPath, EDataVersion dataVersion) {
        Dictionary.init(dataVersion);
        List<DivisionBean> list = Dictionary.getAll();
        try {
            GBT2260.addToLucene(list.toArray(new DivisionBean[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void init(String luceneTmpPath, InputStream inputStream) {
        Dictionary.init(inputStream);
        List<DivisionBean> list = Dictionary.getAll();
        try {
            GBT2260.addToLucene(list.toArray(new DivisionBean[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addToLucene(DivisionBean ... beans) throws IOException {
        Path path = Paths.get(luceneTmpFilePath, new String[0]);
        FSDirectory directory = FSDirectory.open((Path)path);
        StandardAnalyzer analyzer = new StandardAnalyzer();
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig((Analyzer)analyzer);
        indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        IndexWriter indexWriter = new IndexWriter((Directory)directory, indexWriterConfig);
        for (DivisionBean bean : beans) {
            Document document = new Document();
            document.add((IndexableField)new TextField("code", bean.getCode().toString(), Field.Store.YES));
            document.add((IndexableField)new TextField("content", bean.toString(), Field.Store.YES));
            indexWriter.addDocument((Iterable)document);
        }
        indexWriter.close();
    }

    public static DivisionBean getByCode(String code) {
        return Dictionary.getByCode(code);
    }

    public static List<DivisionBean> getSomeByName(String name, int size) {
        if (null == name || "".equals(name)) {
            return null;
        }
        ArrayList<DivisionBean> result = new ArrayList<DivisionBean>();
        try {
            ScoreDoc[] scoreDocs;
            Path path = Paths.get(luceneTmpFilePath, new String[0]);
            FSDirectory directory = FSDirectory.open((Path)path);
            StandardAnalyzer analyzer = new StandardAnalyzer();
            DirectoryReader indexReader = DirectoryReader.open((Directory)directory);
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)indexReader);
            QueryParser queryParser = new QueryParser("content", (Analyzer)analyzer);
            Query query = queryParser.parse(name);
            TopDocs topDocs = indexSearcher.search(query, size);
            for (ScoreDoc scoreDoc : scoreDocs = topDocs.scoreDocs) {
                Document document = indexSearcher.doc(scoreDoc.doc);
                String code = document.get("code");
                DivisionBean bean = Dictionary.getByCode(code);
                result.add(bean);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static DivisionBean getByName(String name) {
        List<DivisionBean> some = GBT2260.getSomeByName(name, 1);
        if (some == null || some.size() < 1) {
            return null;
        }
        return some.get(0);
    }
}

