/*
 * Decompiled with CFR 0.152.
 */
package top.hmtools.dictionary;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import top.hmtools.beans.DivisionBean;
import top.hmtools.enums.EDataVersion;
import top.hmtools.exception.InvalidCodeException;

public class Dictionary {
    private static Map<String, DivisionBean> DICTIONARIES = new HashMap<String, DivisionBean>();
    private static Map<String, String> temp_dict_province = new HashMap<String, String>();
    private static Map<String, String> temp_dict_city = new HashMap<String, String>();
    private static Map<String, String> temp_dict_district = new HashMap<String, String>();
    private static List<DivisionBean> DIVISIONBEANS = new ArrayList<DivisionBean>();
    private static EDataVersion currentDataVersion;

    public static void init() {
        Dictionary.init(EDataVersion.getLast());
    }

    public static void init(EDataVersion dataVersion) {
        currentDataVersion = dataVersion;
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("datas/" + (Object)((Object)dataVersion));
        Dictionary.init(inputStream);
    }

    public static void init(InputStream inputStream) {
        BufferedReader rr = new BufferedReader(new InputStreamReader(inputStream));
        try {
            while (rr.ready()) {
                String line = rr.readLine();
                String[] split = null;
                if (line.contains(",")) {
                    split = line.split(",");
                } else if (line.contains("\t")) {
                    split = line.split("\t");
                }
                String code = split[0].trim();
                String name = split[1].trim();
                if (code.endsWith("0000")) {
                    temp_dict_province.put(code, name);
                    continue;
                }
                if (code.endsWith("00") && !code.endsWith("0000")) {
                    temp_dict_city.put(code, name);
                    continue;
                }
                temp_dict_district.put(code, name);
            }
            for (Map.Entry<String, String> item : temp_dict_province.entrySet()) {
                Dictionary.addData(item.getKey(), item.getValue());
            }
            for (Map.Entry<String, String> item : temp_dict_city.entrySet()) {
                Dictionary.addData(item.getKey(), item.getValue());
            }
            for (Map.Entry<String, String> item : temp_dict_district.entrySet()) {
                Dictionary.addData(item.getKey(), item.getValue());
            }
            Collections.sort(DIVISIONBEANS, new Comparator<DivisionBean>(){

                @Override
                public int compare(DivisionBean aaa, DivisionBean bbb) {
                    return Integer.valueOf(aaa.getCode()) - Integer.valueOf(bbb.getCode());
                }
            });
        }
        catch (IOException e) {
            System.err.println("Error in loading GB2260 data!");
            throw new RuntimeException(e);
        }
    }

    public static void addData(String code, String name) {
        try {
            boolean isCity;
            if (code.length() != 6) {
                throw new InvalidCodeException("Invalid code");
            }
            DivisionBean divisionBean = new DivisionBean();
            divisionBean.setCode(code);
            boolean isProvince = code.endsWith("0000");
            if (isProvince) {
                divisionBean.setProvince(name);
                DICTIONARIES.put(divisionBean.getCode(), divisionBean);
                DIVISIONBEANS.add(divisionBean);
                return;
            }
            String provinceCode = code.substring(0, 2) + "0000";
            String provinceName = temp_dict_province.get(provinceCode);
            divisionBean.setProvince(provinceName);
            boolean bl = isCity = code.endsWith("00") && !code.endsWith("0000");
            if (isCity) {
                divisionBean.setCity(name);
                divisionBean.setParentCode(provinceCode);
                DICTIONARIES.get(provinceCode).addChildren(divisionBean);
                DIVISIONBEANS.add(divisionBean);
                return;
            }
            String cityCode = code.substring(0, 4) + "00";
            String cityName = temp_dict_city.get(cityCode);
            divisionBean.setCity(cityName);
            divisionBean.setDistrict(name);
            Map<String, DivisionBean> cities = DICTIONARIES.get(provinceCode).getChildren();
            if (cityName == null || "".equals(cityName)) {
                divisionBean.setParentCode(provinceCode);
                DICTIONARIES.get(provinceCode).addChildren(divisionBean);
            } else {
                divisionBean.setParentCode(cityCode);
                cities.get(cityCode).addChildren(divisionBean);
            }
            DIVISIONBEANS.add(divisionBean);
        }
        catch (Exception e) {
            System.out.println("add " + code + "(" + name + ")" + " fail : " + e.getMessage());
        }
    }

    public static DivisionBean getByCode(String code) {
        if (code == null || "".equals(code)) {
            return null;
        }
        if (code.length() != 6) {
            return null;
        }
        try {
            if (code.endsWith("0000")) {
                return DICTIONARIES.get(code);
            }
            String provinceCode = code.substring(0, 2) + "0000";
            if (code.endsWith("00") && !code.endsWith("0000")) {
                return DICTIONARIES.get(provinceCode).getChildren().get(code);
            }
            String cityCode = code.subSequence(0, 4) + "00";
            if (temp_dict_city.containsKey(cityCode)) {
                return DICTIONARIES.get(provinceCode).getChildren().get(cityCode).getChildren().get(code);
            }
            return DICTIONARIES.get(provinceCode).getChildren().get(code);
        }
        catch (Exception e) {
            System.out.println("get DivisionBean info fail : " + e.getMessage());
            return null;
        }
    }

    public static List<DivisionBean> getAll() {
        ArrayList<DivisionBean> result = new ArrayList<DivisionBean>();
        result.addAll(DIVISIONBEANS);
        return result;
    }

    public static List<DivisionBean> getAllProvince() {
        ArrayList<DivisionBean> result = new ArrayList<DivisionBean>();
        result.addAll(DICTIONARIES.values());
        return result;
    }

    public static String getCurrentDataVersion() {
        return currentDataVersion != null ? currentDataVersion.toString() : "\u7528\u6237\u81ea\u5b9a\u4e49\u7248\u672c";
    }
}

