/*
 * Decompiled with CFR 0.152.
 */
package top.infra.maven;

import java.util.Optional;
import java.util.Properties;
import top.infra.maven.CiOptionContext;

public interface CiOption {
    default public Optional<String> calculateValue(CiOptionContext context) {
        return Optional.empty();
    }

    default public String envVariableName(String propertyName) {
        String name = this.name(propertyName);
        return name.startsWith("CI_OPT_") ? name : "CI_OPT_" + name;
    }

    default public Optional<String> findInProperties(CiOptionContext context) {
        return this.findInProperties(this.getPropertyName(), context);
    }

    default public Optional<String> findInProperties(String propertyName, CiOptionContext ciOptionContext) {
        return this.findInProperties(propertyName, ciOptionContext.getSystemProperties(), ciOptionContext.getUserProperties());
    }

    default public Optional<String> findInProperties(String propertyName, Properties systemProperties, Properties userProperties) {
        String systemPropertyName = this.systemPropertyName(propertyName);
        Optional<String> systemProperty = Optional.ofNullable(systemProperties.getProperty(systemPropertyName));
        return systemProperty.isPresent() ? systemProperty : Optional.ofNullable(userProperties.getProperty(propertyName));
    }

    public Optional<String> getDefaultValue();

    default public String getEnvVariableName() {
        return this.envVariableName(this.getPropertyName());
    }

    public String getPropertyName();

    default public String getSystemPropertyName() {
        return this.systemPropertyName(this.getPropertyName());
    }

    default public Optional<String> getValue(CiOptionContext context) {
        Optional<String> foundInProperties = this.findInProperties(context);
        Optional<String> value = foundInProperties.isPresent() ? foundInProperties : this.calculateValue(context);
        return value.isPresent() ? value : this.getDefaultValue();
    }

    public String name();

    default public String name(String propertyName) {
        boolean propertyNameEmpty;
        boolean bl = propertyNameEmpty = propertyName == null || propertyName.isEmpty();
        if (propertyNameEmpty) {
            throw new IllegalArgumentException("propertyName must not empty");
        }
        return propertyName.replaceAll("-", "").replaceAll("\\.", "_").toUpperCase();
    }

    default public Optional<String> setProperties(CiOptionContext context, Properties properties) {
        Optional<String> result;
        Optional<String> foundInProperties = this.findInProperties(context);
        if (foundInProperties.isPresent()) {
            Optional<String> got = this.getValue(context);
            if (got.map(value -> value.equals(foundInProperties.get())).orElse(Boolean.FALSE).booleanValue()) {
                properties.setProperty(this.getPropertyName(), foundInProperties.get());
            } else {
                got.ifPresent(value -> properties.setProperty(this.getPropertyName(), (String)value));
            }
            result = foundInProperties;
        } else {
            Optional<String> calculated = this.calculateValue(context);
            String propertyValue = calculated.orElseGet(() -> this.getDefaultValue().orElse(null));
            if (propertyValue != null) {
                properties.setProperty(this.getPropertyName(), propertyValue);
            }
            result = Optional.ofNullable(propertyValue);
        }
        return result;
    }

    default public String systemPropertyName(String propertyName) {
        return String.format("env.%s", this.envVariableName(propertyName));
    }
}

