/*
 * Decompiled with CFR 0.152.
 */
package top.infra.maven;

import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public interface Ordered
extends Comparable<Ordered> {
    public static final int HIGHEST_PRECEDENCE = Integer.MIN_VALUE;
    public static final int LOWEST_PRECEDENCE = Integer.MAX_VALUE;
    public static final Comparator<Ordered> ORDERED_COMPARATOR = (o1, o2) -> {
        int result = o1 != null && o2 != null ? Integer.compare(o1.getOrder(), o2.getOrder()) : (o1 != null ? -1 : (o2 != null ? 1 : 0));
        return result;
    };

    @Override
    default public int compareTo(@NotNull Ordered o2) {
        return ORDERED_COMPARATOR.compare(this, o2);
    }

    default public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

