/*
 * Decompiled with CFR 0.152.
 */
package top.infra.maven.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.maven.cli.CliRequest;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.profile.ProfileActivationContext;
import top.infra.maven.CiOptionContext;
import top.infra.maven.extension.shared.CiOptions;
import top.infra.maven.utils.SystemUtils;

public abstract class MavenUtils {
    public static final String PROP_MAVEN_MULTIMODULEPROJECTDIRECTORY = "maven.multiModuleProjectDirectory";

    public static Boolean cmdArgOffline(CliRequest cliRequest) {
        return cliRequest.getCommandLine().hasOption('o');
    }

    public static Boolean cmdArgUpdateSnapshots(CliRequest cliRequest) {
        return cliRequest.getCommandLine().hasOption('U');
    }

    public static Optional<String> findInProperties(String propertyName, CiOptionContext ciOptionContext) {
        return MavenUtils.findInProperties(propertyName, ciOptionContext.getSystemProperties(), ciOptionContext.getUserProperties());
    }

    public static Optional<String> findInProperties(String propertyName, Properties systemProperties, Properties userProperties) {
        String systemPropertyName = CiOptions.systemPropertyName(propertyName);
        Optional<String> systemProperty = Optional.ofNullable(systemProperties.getProperty(systemPropertyName));
        return systemProperty.isPresent() ? systemProperty : Optional.ofNullable(userProperties.getProperty(propertyName));
    }

    public static void reportProblem(String title, Exception error, Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        String message = String.format("%s: project='%s' profile='%s'", title, MavenUtils.projectName(context), MavenUtils.profileId(profile));
        MavenUtils.registerProblem(message, error, profile.getLocation((Object)""), problems);
    }

    private static void registerProblem(String message, Exception error, InputLocation location, ModelProblemCollector problems) {
        ModelProblemCollectorRequest request = MavenUtils.problemRequest().setMessage(message).setException(error).setLocation(location);
        problems.add(request);
    }

    private static ModelProblemCollectorRequest problemRequest() {
        return new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE);
    }

    public static String profileId(Profile profile) {
        return profile == null || profile.getId() == null ? "" : profile.getId();
    }

    public static String projectName(ProfileActivationContext context) {
        String missing = "<missing>";
        File basedir = context.getProjectDirectory();
        if (basedir == null) {
            return "<missing>";
        }
        File pomFile = new File(basedir, "pom.xml");
        if (pomFile.exists()) {
            Model model = MavenUtils.readMavenModel(pomFile);
            String artifactId = model.getArtifactId();
            if (artifactId != null) {
                return artifactId;
            }
            return "<missing>";
        }
        return basedir.getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Model readMavenModel(File pomFile) {
        try (FileInputStream fileInput = new FileInputStream(pomFile);){
            InputStreamReader fileReader = new InputStreamReader((InputStream)fileInput, StandardCharsets.UTF_8);
            MavenXpp3Reader pomReader = new MavenXpp3Reader();
            Model model = pomReader.read((Reader)fileReader);
            return model;
        }
        catch (Exception ex) {
            return new Model();
        }
    }

    private static String propertyValue(Profile profile) {
        return profile.getActivation().getProperty().getValue();
    }

    public static Path executionRootPath(CliRequest cliRequest, CiOptionContext ciOptionContext) {
        return MavenUtils.mavenMultiModuleProjectDirectory(ciOptionContext.getSystemProperties()).orElseGet(() -> {
            Optional<Path> argFile = MavenUtils.cmdArgFile(cliRequest).map(x$0 -> Paths.get(x$0, new String[0])).filter(path -> path.toFile().exists());
            Path result = argFile.isPresent() ? argFile.map(path -> path.toFile().isDirectory() ? path : path.getParent()).get() : Paths.get(Optional.ofNullable(cliRequest.getWorkingDirectory()).orElseGet(SystemUtils::systemUserDir), new String[0]);
            return result;
        });
    }

    public static Optional<String> cmdArgFile(CliRequest cliRequest) {
        CommandLine commandLine = cliRequest.getCommandLine();
        Optional<String> result = commandLine.hasOption('f') ? Optional.ofNullable(commandLine.getOptionValue('f')) : Optional.empty();
        return result;
    }

    private static Optional<Path> mavenMultiModuleProjectDirectory(Properties systemProperties) {
        String value;
        Optional<Path> result = systemProperties != null ? Optional.ofNullable((value = systemProperties.getProperty(PROP_MAVEN_MULTIMODULEPROJECTDIRECTORY)) != null ? Paths.get(value, new String[0]) : null) : Optional.empty();
        return result;
    }

    public static Properties systemProperties(EventSpy.Context context) {
        return (Properties)context.getData().get("systemProperties");
    }

    public static Path userHomeDotM2() {
        return Paths.get(SystemUtils.systemUserHome(), ".m2");
    }

    public static Properties userProperties(EventSpy.Context context) {
        return (Properties)context.getData().get("userProperties");
    }
}

