/*
 * Decompiled with CFR 0.152.
 */
package top.infra.maven.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import top.infra.maven.logging.Logger;

public class PropertiesUtils {
    @Deprecated
    public static Properties toProperties(Map<String, String> map) {
        Properties result;
        if (map != null) {
            result = new Properties();
            result.putAll(map);
        } else {
            result = null;
        }
        return result;
    }

    public static Properties merge(Properties properties, Properties intoProperties) {
        properties.stringPropertyNames().forEach(name -> intoProperties.setProperty((String)name, properties.getProperty((String)name)));
        return intoProperties;
    }

    public static Map<String, Object> mapFromProperties(Properties properties) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> result.put(key.toString(), value.toString())));
        return result;
    }

    public static String logProperties(Logger logger, String title, Properties properties, Pattern pattern) {
        StringBuilder sb = new StringBuilder(pattern != null ? pattern.pattern() : "");
        String[] propNames = (String[])properties.stringPropertyNames().stream().filter(propName -> pattern == null || pattern.matcher((CharSequence)propName).matches()).sorted().toArray(String[]::new);
        IntStream.range(0, propNames.length).forEach(idx -> {
            String name = propNames[idx];
            String value = properties.getProperty(name);
            String line = String.format("%s[%03d] %s=%s", title, idx, name, value);
            sb.append(System.lineSeparator());
            sb.append(line);
            if (logger != null) {
                logger.info(line);
            }
        });
        return PropertiesUtils.maskSecrets(sb.toString());
    }

    public static String maskSecrets(String text) {
        return "" + text.replaceAll("KEYNAME=.+", "KEYNAME=<secret>").replaceAll("keyname=.+", "keyname=<secret>").replaceAll("LOGIN=.+", "LOGIN=<secret>").replaceAll("login=.+", "login=<secret>").replaceAll("ORGANIZATION=.+", "ORGANIZATION=<secret>").replaceAll("organization=.+", "organization=<secret>").replaceAll("PASS=.+", "PASS=<secret>").replaceAll("pass=.+", "pass=<secret>").replaceAll("PASSWORD=.+", "PASSWORD=<secret>").replaceAll("password=.+", "password=<secret>").replaceAll("PASSPHRASE=.+", "PASSPHRASE=<secret>").replaceAll("passphrase=.+", "passphrase=<secret>").replaceAll("TOKEN=.+", "TOKEN=<secret>").replaceAll("token=.+", "token=<secret>").replaceAll("USER=.+", "USER=<secret>").replaceAll("user=.+", "user=<secret>").replaceAll("USERNAME=.+", "USERNAME=<secret>").replaceAll("username=.+", "username=<secret>");
    }

    public static String toString(Map<String, String> properties, Pattern pattern) {
        StringBuilder sb = new StringBuilder(pattern != null ? pattern.pattern() : "").append(System.lineSeparator());
        String[] names = (String[])properties.keySet().stream().filter(name -> pattern == null || pattern.matcher((CharSequence)name).matches()).sorted().toArray(String[]::new);
        IntStream.range(0, names.length).forEach(idx -> {
            if (idx > 0) {
                sb.append(System.lineSeparator());
            }
            sb.append(String.format("%03d ", idx));
            String name = names[idx];
            sb.append(name).append("=").append((String)properties.get(name));
        });
        return PropertiesUtils.maskSecrets(sb.toString());
    }
}

