/*
 * Decompiled with CFR 0.152.
 */
package top.infra.maven.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import top.infra.maven.logging.Logger;

public class PropertiesUtils {
    @Deprecated
    public static Properties toProperties(Map<String, String> map) {
        Properties result;
        if (map != null) {
            result = new Properties();
            result.putAll(map);
        } else {
            result = null;
        }
        return result;
    }

    public static Properties merge(Properties properties, Properties intoProperties) {
        properties.stringPropertyNames().forEach(name -> intoProperties.setProperty((String)name, properties.getProperty((String)name)));
        return intoProperties;
    }

    public static Map<String, Object> mapFromProperties(Properties properties) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> result.put(key.toString(), value.toString())));
        return result;
    }

    public static String logProperties(Logger logger, String title, Properties properties, Pattern pattern) {
        StringBuilder sb = new StringBuilder(pattern != null ? pattern.pattern() : "");
        String[] propNames = (String[])properties.stringPropertyNames().stream().filter(propName -> pattern == null || pattern.matcher((CharSequence)propName).matches()).sorted().toArray(String[]::new);
        IntStream.range(0, propNames.length).forEach(idx -> {
            String name = propNames[idx];
            String value = properties.getProperty(name);
            String line = PropertiesUtils.maskSecrets(String.format("%s[%03d] %s=%s", title, idx, name, value));
            sb.append(System.lineSeparator());
            sb.append(line);
            if (logger != null) {
                logger.info(line);
            }
        });
        return PropertiesUtils.maskSecrets(sb.toString());
    }

    public static String maskSecrets(String text) {
        return "" + text.replaceAll("KEY=(?!null).*", "KEY=[secure]").replaceAll("key=(?!null).*", "key=[secure]").replaceAll("KEYNAME=(?!null).*", "KEYNAME=[secure]").replaceAll("keyname=(?!null).*", "keyname=[secure]").replaceAll("LOGIN=(?!null).*", "LOGIN=[secure]").replaceAll("login=(?!null).*", "login=[secure]").replaceAll("ORGANIZATION=(?!null).*", "ORGANIZATION=[secure]").replaceAll("organization=(?!null).*", "organization=[secure]").replaceAll("PASS=(?!null).*", "PASS=[secure]").replaceAll("pass=(?!null).*", "pass=[secure]").replaceAll("PASSWORD=(?!null).*", "PASSWORD=[secure]").replaceAll("password=(?!null).*", "password=[secure]").replaceAll("PASSPHRASE=(?!null).*", "PASSPHRASE=[secure]").replaceAll("passphrase=(?!null).*", "passphrase=[secure]").replaceAll("TOKEN=(?!null).*", "TOKEN=[secure]").replaceAll("token=(?!null).*", "token=[secure]").replaceAll("USER=(?!null).*", "USER=[secure]").replaceAll("user=(?!null).*", "user=[secure]").replaceAll("USERNAME=(?!null).*", "USERNAME=[secure]").replaceAll("username=(?!null).*", "username=[secure]");
    }

    public static String toString(Map<String, String> properties, Pattern pattern) {
        StringBuilder sb = new StringBuilder(pattern != null ? pattern.pattern() : "").append(System.lineSeparator());
        String[] names = (String[])properties.keySet().stream().filter(name -> pattern == null || pattern.matcher((CharSequence)name).matches()).sorted().toArray(String[]::new);
        IntStream.range(0, names.length).forEach(idx -> {
            if (idx > 0) {
                sb.append(System.lineSeparator());
            }
            sb.append(String.format("%03d ", idx));
            String name = names[idx];
            sb.append(name).append("=").append((String)properties.get(name));
        });
        return PropertiesUtils.maskSecrets(sb.toString());
    }
}

