/*
 * Decompiled with CFR 0.152.
 */
package top.infra.maven;

import java.util.Optional;
import java.util.Properties;
import top.infra.maven.CiOptionContext;
import top.infra.maven.extension.shared.CiOptions;
import top.infra.maven.utils.MavenUtils;

public interface CiOption {
    public String name();

    public Optional<String> getDefaultValue();

    default public String getEnvVariableName() {
        return CiOptions.envVariableName(this.getPropertyName());
    }

    public String getPropertyName();

    default public String getSystemPropertyName() {
        return CiOptions.systemPropertyName(this.getPropertyName());
    }

    default public Optional<String> getValue(CiOptionContext context) {
        Optional<String> foundInProperties = this.findInProperties(context.getSystemProperties(), context.getUserProperties());
        Optional<String> value = foundInProperties.isPresent() ? foundInProperties : this.calculateValue(context);
        return value.isPresent() ? value : this.getDefaultValue();
    }

    default public Optional<String> calculateValue(CiOptionContext context) {
        return Optional.empty();
    }

    default public Optional<String> findInProperties(Properties systemProperties, Properties userProperties) {
        return MavenUtils.findInProperties(this.getPropertyName(), systemProperties, userProperties);
    }

    default public Optional<String> setProperties(CiOptionContext context, Properties properties) {
        Optional<String> result;
        Optional<String> foundInProperties = this.findInProperties(context.getSystemProperties(), context.getUserProperties());
        if (foundInProperties.isPresent()) {
            Optional<String> got = this.getValue(context);
            if (got.map(value -> value.equals(foundInProperties.get())).orElse(Boolean.FALSE).booleanValue()) {
                properties.setProperty(this.getPropertyName(), foundInProperties.get());
            } else {
                got.ifPresent(value -> properties.setProperty(this.getPropertyName(), (String)value));
            }
            result = foundInProperties;
        } else {
            Optional<String> calculated = this.calculateValue(context);
            String propertyValue = calculated.orElseGet(() -> this.getDefaultValue().orElse(null));
            if (propertyValue != null) {
                properties.setProperty(this.getPropertyName(), propertyValue);
            }
            result = Optional.ofNullable(propertyValue);
        }
        return result;
    }
}

