/*
 * Decompiled with CFR 0.152.
 */
package top.infra.maven.extension.shared;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.cli.CliRequest;
import top.infra.maven.CiOption;
import top.infra.maven.CiOptionContext;
import top.infra.maven.extension.CiOptionFactoryBean;
import top.infra.maven.extension.MavenEventAware;
import top.infra.maven.extension.shared.CiOptions;
import top.infra.maven.logging.Logger;
import top.infra.maven.logging.LoggerPlexusImpl;
import top.infra.maven.utils.PropertiesUtils;
import top.infra.maven.utils.SupportFunction;

@Named
@Singleton
public class CiOptionInitEventAware
implements MavenEventAware {
    private final Logger logger;
    private Map<Class<?>, List<CiOption>> optionCollections;

    @Inject
    public CiOptionInitEventAware(org.codehaus.plexus.logging.Logger logger, List<CiOptionFactoryBean> optionFactoryBeans) {
        this.logger = new LoggerPlexusImpl(logger);
        this.optionCollections = optionFactoryBeans.stream().sorted().collect(Collectors.toMap(CiOptionFactoryBean::getType, CiOptionFactoryBean::getOptions, (e1, e2) -> e1, LinkedHashMap::new));
    }

    @Override
    public boolean afterInit() {
        return true;
    }

    @Override
    public void afterInit(CliRequest cliRequest, CiOptionContext ciOptContext) {
        this.initCiOptions(ciOptContext);
    }

    @Override
    public int getOrder() {
        return 6;
    }

    private void initCiOptions(CiOptionContext ciOptContext) {
        this.logger.info(SupportFunction.logStart(this, "initCiOptions", new Object[0]));
        Properties userProperties = ciOptContext.getUserProperties();
        Properties ciOptProperties = ciOptContext.setCiOptPropertiesInto(this.optionCollections.values(), userProperties);
        if (this.logger.isInfoEnabled()) {
            this.logger.info(String.format("    There are [%s] groups of options.", this.optionCollections.size()));
            ArrayList types = new ArrayList(this.optionCollections.keySet());
            ArrayList<List<CiOption>> groups = new ArrayList<List<CiOption>>(this.optionCollections.values());
            IntStream.range(0, this.optionCollections.size()).forEach(idx -> {
                List group = (List)groups.get(idx);
                this.logger.info(String.format("    option group index: [%s], name: [%s], size: [%s]", String.format("%02d ", idx), ((Class)types.get(idx)).getSimpleName(), String.format("%03d ", group.size())));
                group.stream().sorted().forEach(ciOption -> {
                    String displayName = ciOption.getEnvVariableName();
                    String displayValue = ciOptProperties.getProperty(ciOption.getPropertyName(), "null");
                    this.logger.info(PropertiesUtils.maskSecrets(String.format("        %s=%s", displayName, displayValue)));
                });
            });
            Properties systemProperties = ciOptContext.getSystemProperties();
            PropertiesUtils.logProperties(this.logger, "    ciOptionContext.systemProperties", systemProperties, CiOptions.PATTERN_VARS_ENV_DOT_CI);
            PropertiesUtils.logProperties(this.logger, "    ciOptionContext.userProperties", userProperties, null);
        }
        this.logger.info(SupportFunction.logEnd(this, "initCiOptions", Void.TYPE, new Object[0]));
    }
}

