/*
 * Decompiled with CFR 0.152.
 */
package top.infra.maven.utils;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class UrlUtils {
    private static final Pattern PATTERN_URL = Pattern.compile("^(.+://|git@)([^/\\:]+(:\\d+)?).*$");

    private UrlUtils() {
    }

    public static Optional<String> domainOrHostFromUrl(String url) {
        Matcher matcher = PATTERN_URL.matcher(url);
        Optional<String> result = matcher.matches() ? Optional.ofNullable(matcher.group(2)) : Optional.empty();
        return result;
    }

    public static Optional<String> urlWithoutPath(String url) {
        Matcher matcher = PATTERN_URL.matcher(url);
        Optional<String> result = matcher.matches() ? Optional.of(matcher.group(1) + matcher.group(2)) : Optional.empty();
        return result;
    }
}

