/*
 * Decompiled with CFR 0.152.
 */
package top.infra.maven;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import top.infra.maven.CiOption;
import top.infra.maven.extension.shared.CiOptions;
import top.infra.maven.utils.PropertiesUtils;

public class CiOptionContext {
    private final Properties systemProperties;
    private final Properties userProperties;

    public CiOptionContext(Properties systemProperties, Properties userProperties) {
        this.systemProperties = systemProperties;
        this.userProperties = userProperties;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public Properties getUserProperties() {
        return this.userProperties;
    }

    public Properties setCiOptPropertiesInto(Collection<List<CiOption>> optionGroups, Properties ... targetProperties) {
        Properties properties = new Properties();
        optionGroups.stream().flatMap(group -> group.stream().sorted()).forEach(ciOption -> {
            if (!ciOption.name().equals(CiOptions.name(ciOption.getPropertyName()))) {
                throw new IllegalArgumentException(String.format("invalid property name [%s] for enum name [%s]", ciOption.name(), ciOption.getPropertyName()));
            }
            ciOption.setProperties(this, properties);
        });
        for (Properties target : targetProperties) {
            PropertiesUtils.merge(properties, target);
        }
        return properties;
    }

    public void updateSystemProperties(Properties externalProperties) {
        if (externalProperties != null) {
            for (String name : externalProperties.stringPropertyNames()) {
                String key = CiOptions.systemPropertyName(name);
                String value = externalProperties.getProperty(name);
                if (value == null || this.systemProperties.containsKey(key)) continue;
                this.systemProperties.setProperty(key, value);
            }
        }
    }
}

