/*
 * Decompiled with CFR 0.152.
 */
package top.infra.maven.extension.shared;

import java.io.File;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.cli.CliRequest;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.internal.aether.DefaultRepositorySystemSessionFactory;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import top.infra.maven.CiOptionContext;
import top.infra.maven.extension.MavenEventAware;
import top.infra.maven.extension.shared.GlobalOption;
import top.infra.maven.extension.shared.MavenProjectInfo;
import top.infra.maven.logging.Logger;
import top.infra.maven.logging.LoggerPlexusImpl;
import top.infra.maven.utils.SupportFunction;

@Named
@Singleton
public class MavenProjectInfoEventAware
implements MavenEventAware {
    private final Logger logger;
    private final ProjectBuilder projectBuilder;
    private final DefaultRepositorySystemSessionFactory repositorySessionFactory;
    private MavenExecutionRequest mavenExecutionCopied;
    private MavenProjectInfo rootProjectInfo;

    @Inject
    public MavenProjectInfoEventAware(org.codehaus.plexus.logging.Logger logger, ProjectBuilder projectBuilder, DefaultRepositorySystemSessionFactory repositorySessionFactory) {
        this.logger = new LoggerPlexusImpl(logger);
        this.projectBuilder = projectBuilder;
        this.repositorySessionFactory = repositorySessionFactory;
    }

    @Override
    public int getOrder() {
        return 12;
    }

    public MavenProjectInfo getRootProjectInfo() {
        if (this.rootProjectInfo == null && this.mavenExecutionCopied != null) {
            this.rootProjectInfo = this.resolveRootProject();
        }
        return this.rootProjectInfo;
    }

    private MavenProjectInfo resolveRootProject() {
        this.logger.info(SupportFunction.logStart(this, "resolve", new Object[0]));
        MavenProjectInfo projectInfo = this.resolve(this.mavenExecutionCopied.getPom());
        this.logger.info(SupportFunction.logEnd(this, "resolve", projectInfo, new Object[0]));
        return projectInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenProjectInfo resolve(File pomFile) {
        boolean repositorySystemSessionNull = this.createRepositorySystemSessionIfAbsent(this.mavenExecutionCopied);
        ProjectBuildingRequest projectBuildingRequest = this.mavenExecutionCopied.getProjectBuildingRequest();
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("    getMavenProjectInfo pomFile: [%s]", pomFile));
            }
            MavenProjectInfo mavenProjectInfo = MavenProjectInfo.newProjectInfoByReadPom(this.logger, pomFile).orElseGet(() -> MavenProjectInfo.newProjectInfoByBuildProject(this.logger, this.projectBuilder, pomFile, projectBuildingRequest));
            return mavenProjectInfo;
        }
        finally {
            if (repositorySystemSessionNull) {
                projectBuildingRequest.setRepositorySession(null);
            }
        }
    }

    private boolean createRepositorySystemSessionIfAbsent(MavenExecutionRequest request) {
        boolean repositorySystemSessionNull;
        ProjectBuildingRequest projectBuildingRequest = request.getProjectBuildingRequest();
        if (projectBuildingRequest != null) {
            boolean bl = repositorySystemSessionNull = projectBuildingRequest.getRepositorySession() == null;
            if (repositorySystemSessionNull) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(String.format("    repositorySystemSession not found in %s", projectBuildingRequest));
                }
                DefaultRepositorySystemSession repositorySystemSession = this.repositorySessionFactory.newRepositorySession(request);
                projectBuildingRequest.setRepositorySession((RepositorySystemSession)repositorySystemSession);
            }
        } else {
            repositorySystemSessionNull = true;
        }
        return repositorySystemSessionNull;
    }

    @Override
    public boolean onProjectBuildingRequest() {
        return true;
    }

    @Override
    public void onProjectBuildingRequest(CliRequest cliRequest, MavenExecutionRequest mavenExecution, ProjectBuildingRequest projectBuilding, CiOptionContext ciOptContext) {
        this.mavenExecutionCopied = DefaultMavenExecutionRequest.copy((MavenExecutionRequest)mavenExecution);
        if (!GlobalOption.FAST.getValue(ciOptContext).map(Boolean::parseBoolean).orElse(Boolean.FALSE).booleanValue()) {
            this.rootProjectInfo = this.resolveRootProject();
        } else {
            this.logger.info("    Lazy resolving project version under fast mode.");
        }
    }
}

