/*
 * Decompiled with CFR 0.152.
 */
package top.infra.maven.extension.activator;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.codehaus.plexus.logging.Logger;
import top.infra.maven.extension.activator.CustomActivator;
import top.infra.maven.extension.activator.model.ActivatorModelResolver;
import top.infra.maven.extension.activator.model.ProjectBuilderActivatorModelResolver;
import top.infra.maven.logging.LoggerPlexusImpl;
import top.infra.maven.utils.MavenUtils;

public abstract class AbstractCustomActivator
implements CustomActivator {
    protected final top.infra.maven.logging.Logger logger;
    protected final ActivatorModelResolver resolver;
    private final Map<String, Boolean> profileMemento;

    protected AbstractCustomActivator(Logger logger, ProjectBuilderActivatorModelResolver resolver) {
        this.logger = new LoggerPlexusImpl(logger);
        this.resolver = resolver;
        this.profileMemento = new LinkedHashMap<String, Boolean>();
    }

    public boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        try {
            Boolean result;
            if (!this.presentInConfig(profile, context, problems)) {
                result = false;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(String.format("    %s profile '%s' not presentInConfig", this.getName(), MavenUtils.profileId(profile)));
                    this.logger.debug(String.format("    %s project='%s' profile='%s' result='false'", this.getName(), MavenUtils.projectName(context), MavenUtils.profileId(profile)));
                }
            } else {
                Optional<Model> project = this.resolver.resolveModel(profile, context);
                if (project.isPresent()) {
                    String mementoKey = AbstractCustomActivator.mementoKey(profile, project.get().getPomFile());
                    Boolean found = this.profileMemento.get(mementoKey);
                    if (found == null) {
                        result = this.isActive(project.get(), profile, context, problems);
                        if (this.cacheResult()) {
                            this.profileMemento.put(mementoKey, result);
                        }
                        if (result.booleanValue() || this.cacheResult()) {
                            this.logger.info(String.format("    %s project='%s' profile='%s' result='%s'", this.getName(), MavenUtils.projectName(context), MavenUtils.profileId(profile), result));
                        } else if (this.logger.isDebugEnabled()) {
                            this.logger.debug(String.format("    %s project='%s' profile='%s' result='false'", this.getName(), MavenUtils.projectName(context), MavenUtils.profileId(profile)));
                        }
                    } else {
                        result = found;
                    }
                } else {
                    result = false;
                }
            }
            return result;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), ex);
            MavenUtils.reportProblem(ex.getMessage(), ex, profile, context, problems);
            throw ex;
        }
    }

    protected boolean cacheResult() {
        return false;
    }

    public boolean presentInConfig(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        return this.supported(profile) && this.resolver.resolveModel(profile, context).isPresent();
    }

    protected String getName() {
        return this.getClass().getSimpleName();
    }

    protected abstract boolean isActive(Model var1, Profile var2, ProfileActivationContext var3, ModelProblemCollector var4);

    private static String mementoKey(Profile profile, File pomFile) {
        String pom = pomFile != null ? pomFile.getPath() : "";
        return String.format("%s@%s", profile, pom);
    }
}

