/*
 * Decompiled with CFR 0.152.
 */
package top.infra.maven.extension.shared;

import java.util.regex.Pattern;
import top.infra.maven.utils.SupportFunction;

public class CiOptions {
    public static final Pattern PATTERN_VARS_ENV_DOT_CI = Pattern.compile("^env\\.CI_.+");

    public static String systemPropertyName(String propertyName) {
        return String.format("env.%s", CiOptions.envVariableName(propertyName));
    }

    public static String envVariableName(String propertyName) {
        String name = CiOptions.name(propertyName);
        return name.startsWith("CI_OPT_") ? name : "CI_OPT_" + name;
    }

    public static String name(String propertyName) {
        if (SupportFunction.isEmpty(propertyName)) {
            throw new IllegalArgumentException("propertyName must not empty");
        }
        return propertyName.replaceAll("-", "").replaceAll("\\.", "_").toUpperCase();
    }
}

