/*
 * Decompiled with CFR 0.152.
 */
package top.infra.maven.extension.shared;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import top.infra.maven.logging.Logger;
import top.infra.maven.utils.FileUtils;
import top.infra.maven.utils.SupportFunction;

public class MavenProjectInfo {
    private final String artifactId;
    private final String groupId;
    private final String packaging;
    private final String version;
    private final String javaVersion;

    public MavenProjectInfo(String artifactId, String groupId, String packaging, String version, String javaVersion) {
        this.artifactId = artifactId;
        this.groupId = groupId;
        this.packaging = packaging;
        this.version = version;
        this.javaVersion = javaVersion;
    }

    public static Optional<MavenProjectInfo> newProjectInfoByReadPom(Logger logger, File pomFile) {
        MavenXpp3Reader xpp3Reader = new MavenXpp3Reader();
        try {
            Model model = xpp3Reader.read((Reader)new FileReader(pomFile));
            return Optional.of(new MavenProjectInfo(model.getArtifactId(), model.getGroupId(), model.getPackaging(), model.getVersion(), model.getProperties().getProperty("java.version")));
        }
        catch (IOException | IllegalArgumentException | XmlPullParserException ex) {
            if (logger.isWarnEnabled()) {
                logger.warn(String.format("    Failed to read project info from pomFile [%s] (by MavenXpp3Reader)", FileUtils.pathname(pomFile)), ex);
            }
            return Optional.empty();
        }
    }

    public static MavenProjectInfo newProjectInfoByBuildProject(Logger logger, ProjectBuilder projectBuilder, File pomFile, ProjectBuildingRequest projectBuildingRequest) {
        Optional<MavenProject> projectOptional = MavenProjectInfo.buildProject(logger, pomFile, projectBuilder, projectBuildingRequest);
        String artifactId = projectOptional.map(MavenProject::getArtifactId).orElse(null);
        String groupId = projectOptional.map(MavenProject::getGroupId).orElse(null);
        String packaging = projectOptional.map(MavenProject::getPackaging).orElse(null);
        String version = projectOptional.map(MavenProject::getVersion).orElse(null);
        String javaVersion = projectOptional.map(project -> project.getProperties().getProperty("java.version")).orElse(null);
        return new MavenProjectInfo(artifactId, groupId, packaging, version, javaVersion);
    }

    public static Optional<MavenProject> buildProject(Logger logger, File pomFile, ProjectBuilder projectBuilder, ProjectBuildingRequest projectBuildingRequest) {
        Optional<MavenProject> result;
        try {
            DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(projectBuildingRequest);
            request.setActiveProfileIds(Collections.emptyList());
            request.setProcessPlugins(false);
            request.setProfiles(Collections.emptyList());
            request.setResolveDependencies(false);
            request.setValidationLevel(0);
            List buildingResults = projectBuilder.build(Collections.singletonList(pomFile), false, (ProjectBuildingRequest)request);
            result = Optional.of(((ProjectBuildingResult)buildingResults.get(0)).getProject());
        }
        catch (Exception ex) {
            if (logger.isWarnEnabled()) {
                logger.warn(String.format("    Error get project from pom %s. message: %s, stackTrace: %s", pomFile.getPath(), ex.getMessage(), SupportFunction.stackTrace(ex)));
            }
            result = Optional.empty();
        }
        return result;
    }

    public boolean idEquals(Model model) {
        return model != null && this.getId().equals(model.getId());
    }

    public String getId() {
        StringBuilder id = new StringBuilder(64);
        id.append(this.getGroupId() == null ? "[inherited]" : this.getGroupId());
        id.append(":");
        id.append(this.getArtifactId());
        id.append(":");
        id.append(this.getPackaging());
        id.append(":");
        id.append(this.getVersion() == null ? "[inherited]" : this.getVersion());
        return id.toString();
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean idEqualsExceptInheritedGroupId(Model model) {
        boolean result;
        String id = this.getId();
        if (id.startsWith("[inherited]:") && model != null) {
            String modelId = model.getId();
            result = id.substring(id.indexOf(58)).equals(modelId.substring(modelId.indexOf(58)));
        } else {
            result = false;
        }
        return result;
    }

    public String toString() {
        return this.getId();
    }
}

