/*
 * Decompiled with CFR 0.152.
 */
package top.infra.maven.extension.shared;

import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Optional;
import top.infra.maven.CiOption;
import top.infra.maven.CiOptionContext;
import top.infra.maven.extension.shared.GlobalOption;
import top.infra.maven.utils.SystemUtils;

public enum MavenOption implements CiOption
{
    ARGLINE("argLine", ""){}
    ,
    ENFORCER_SKIP("enforcer.skip"){

        @Override
        public Optional<String> calculateValue(CiOptionContext context) {
            return GlobalOption.FAST.getValue(context);
        }
    }
    ,
    MAVEN_CLEAN_SKIP("maven.clean.skip", "true"),
    MAVEN_COMPILER_ENCODING("maven.compiler.encoding", StandardCharsets.UTF_8.name()),
    MVNEXECUTABLE("mvnExecutable"){

        @Override
        public Optional<String> calculateValue(CiOptionContext context) {
            String mvn = SystemUtils.isWindows() ? "mvn.cmd" : "mvn";
            return Optional.ofNullable(context.getSystemProperties().getProperty("maven.home")).map(mvnHome -> Paths.get(mvnHome, "bin", mvn).toString());
        }
    }
    ,
    MAVEN_INSTALL_SKIP("maven.install.skip"),
    MAVEN_JAVADOC_SKIP("maven.javadoc.skip"){

        @Override
        public Optional<String> calculateValue(CiOptionContext context) {
            return Optional.of(GlobalOption.FAST.getValue(context).map(Boolean::parseBoolean).filter(fast -> fast).map(fast -> "true").orElse("false"));
        }
    }
    ,
    GENERATEREPORTS("generateReports"){

        @Override
        public Optional<String> calculateValue(CiOptionContext context) {
            return GlobalOption.FAST.getValue(context).map(Boolean::parseBoolean).filter(fast -> fast).map(fast -> "false");
        }
    }
    ,
    JIRA_PROJECTKEY("jira.projectKey"),
    JIRA_USER("jira.user"){

        @Override
        public Optional<String> getValue(CiOptionContext context) {
            Optional<String> jiraProjectKey = JIRA_PROJECTKEY.getValue(context);
            return jiraProjectKey.isPresent() ? super.getValue(context) : Optional.empty();
        }
    }
    ,
    JIRA_PASSWORD("jira.password"){

        @Override
        public Optional<String> getValue(CiOptionContext context) {
            Optional<String> jiraProjectKey = JIRA_PROJECTKEY.getValue(context);
            return jiraProjectKey.isPresent() ? super.getValue(context) : Optional.empty();
        }
    }
    ,
    LINKXREF("linkXRef"){

        @Override
        public Optional<String> calculateValue(CiOptionContext context) {
            return Optional.ofNullable(GlobalOption.FAST.getValue(context).map(Boolean::parseBoolean).orElse(Boolean.FALSE) != false ? "false" : null);
        }
    }
    ,
    MAVEN_SITE_SKIP("maven.site.skip"){

        @Override
        public Optional<String> calculateValue(CiOptionContext context) {
            return Optional.ofNullable(GENERATEREPORTS.getValue(context).map(Boolean::parseBoolean).orElse(Boolean.TRUE) != false ? null : "true");
        }
    }
    ,
    MAVEN_SITE_DEPLOY_SKIP("maven.site.deploy.skip"){

        @Override
        public Optional<String> calculateValue(CiOptionContext context) {
            return MAVEN_SITE_SKIP.calculateValue(context);
        }
    }
    ,
    MAVEN_SOURCE_SKIP("maven.source.skip"){

        @Override
        public Optional<String> calculateValue(CiOptionContext context) {
            return MAVEN_JAVADOC_SKIP.calculateValue(context);
        }
    }
    ,
    MAVEN_TEST_FAILURE_IGNORE("maven.test.failure.ignore", "false"){

        @Override
        public Optional<String> calculateValue(CiOptionContext context) {
            return GlobalOption.FAST.getValue(context);
        }
    }
    ,
    MAVEN_TEST_SKIP("maven.test.skip"),
    PMD_SKIP("pmd.skip"){

        @Override
        public Optional<String> calculateValue(CiOptionContext context) {
            return Optional.ofNullable(GENERATEREPORTS.calculateValue(context).map(Boolean::parseBoolean).orElse(Boolean.TRUE) != false ? null : "true");
        }
    }
    ,
    PROJECT_BUILD_SOURCEENCODING("project.build.sourceEncoding"),
    PROJECT_REPORTING_OUTPUTENCODING("project.reporting.outputEncoding"),
    SKIPITS("skipITs"){

        @Override
        public Optional<String> calculateValue(CiOptionContext context) {
            return GlobalOption.FAST.getValue(context);
        }
    }
    ,
    SKIPTESTPROJECT("skipTestProject"){

        @Override
        public Optional<String> calculateValue(CiOptionContext context) {
            return GlobalOption.FAST.getValue(context);
        }
    }
    ,
    SKIPTESTS("skipTests", "false"){

        @Override
        public Optional<String> calculateValue(CiOptionContext context) {
            return GlobalOption.FAST.getValue(context);
        }
    }
    ,
    SONAR_BUILDBREAKER_SKIP("sonar.buildbreaker.skip"){

        @Override
        public Optional<String> calculateValue(CiOptionContext context) {
            return Optional.ofNullable(GlobalOption.FAST.getValue(context).map(Boolean::parseBoolean).orElse(Boolean.FALSE) != false ? "true" : null);
        }
    }
    ,
    SPOTBUGS_SKIP("spotbugs.skip"){

        @Override
        public Optional<String> calculateValue(CiOptionContext context) {
            return Optional.ofNullable(GENERATEREPORTS.calculateValue(context).map(Boolean::parseBoolean).orElse(Boolean.TRUE) != false ? null : "true");
        }
    };

    private final String defaultValue;
    private final String propertyName;

    private MavenOption(String propertyName) {
        this(propertyName, (String)null);
    }

    private MavenOption(String propertyName, String defaultValue) {
        this.defaultValue = defaultValue;
        this.propertyName = propertyName;
    }

    @Override
    public Optional<String> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue);
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }
}

