/*
 * Decompiled with CFR 0.152.
 */
package top.infra.maven.extension.internal.activator.model;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.LegacyLocalRepositoryManager;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelCache;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectModelResolver;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import top.infra.maven.extension.internal.activator.model.ReactorModelCache;
import top.infra.maven.shared.extension.activator.model.AbstractActivatorModelResolver;

@Named
@Singleton
public class ProjectBuilderActivatorModelResolver
extends AbstractActivatorModelResolver {
    private final ModelCache modelCache = new ReactorModelCache();
    private final RemoteRepositoryManager repositoryManager;
    private final RepositorySystem repositorySystem;
    private ProjectBuildingRequest projectBuildingRequest;

    @Inject
    public ProjectBuilderActivatorModelResolver(Logger logger, ModelBuilder modelBuilder, RemoteRepositoryManager repositoryManager, RepositorySystem repositorySystem) {
        super(logger, modelBuilder);
        this.repositoryManager = repositoryManager;
        this.repositorySystem = repositorySystem;
    }

    protected ModelBuildingRequest modelBuildingRequest(ProfileActivationContext context, File pomFile) {
        RepositorySystemSession session = LegacyLocalRepositoryManager.overlay((ArtifactRepository)this.projectBuildingRequest.getLocalRepository(), (RepositorySystemSession)this.projectBuildingRequest.getRepositorySession(), (RepositorySystem)this.repositorySystem);
        DefaultModelBuildingRequest modelBuildingRequest = new DefaultModelBuildingRequest();
        RequestTrace trace = RequestTrace.newChild(null, (Object)this.projectBuildingRequest).newChild((Object)modelBuildingRequest);
        List repositories = RepositoryUtils.toRepos((List)this.projectBuildingRequest.getRemoteRepositories());
        ProjectModelResolver modelResolver = new ProjectModelResolver(session, trace, this.repositorySystem, this.repositoryManager, repositories, this.projectBuildingRequest.getRepositoryMerging(), null);
        modelBuildingRequest.setBuildStartTime(this.projectBuildingRequest.getBuildStartTime());
        modelBuildingRequest.setLocationTracking(false);
        modelBuildingRequest.setModelResolver((ModelResolver)modelResolver);
        modelBuildingRequest.setPomFile(pomFile);
        modelBuildingRequest.setSystemProperties(this.projectBuildingRequest.getSystemProperties());
        modelBuildingRequest.setUserProperties(this.projectBuildingRequest.getUserProperties());
        modelBuildingRequest.setValidationLevel(this.projectBuildingRequest.getValidationLevel());
        modelBuildingRequest.setModelCache(this.modelCache);
        return modelBuildingRequest;
    }

    public void setProjectBuildingRequest(ProjectBuildingRequest projectBuildingRequest) {
        this.projectBuildingRequest = projectBuildingRequest;
    }
}

