/*
 * Decompiled with CFR 0.152.
 */
package top.infra.maven.extension.internal.activator.model;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import shaded.top.infra.maven.shared.logging.LoggerPlexusImpl;
import shaded.top.infra.maven.shared.utils.DownloadUtils;
import top.infra.maven.logging.Logger;

@Deprecated
public class RepositoryModelResolver
implements ModelResolver {
    private static final String MAVEN_CENTRAL_URL = "https://repo1.maven.org/maven2";
    private static final String MAVEN_CENTRAL_URL_MIRROR_1 = "http://repo.maven.apache.org/maven2";
    private final Logger logger;
    private File localRepository;
    private Collection<Repository> repositories = new LinkedHashSet<Repository>();

    public RepositoryModelResolver(org.codehaus.plexus.logging.Logger logger) {
        this.logger = new LoggerPlexusImpl(logger);
        Repository central = new Repository();
        central.setId("central");
        central.setUrl(MAVEN_CENTRAL_URL);
        this.repositories.add(central);
        Repository mirror1 = new Repository();
        mirror1.setId("mirror1");
        mirror1.setUrl(MAVEN_CENTRAL_URL_MIRROR_1);
        this.repositories.add(mirror1);
    }

    private RepositoryModelResolver(Logger logger, File localRepository, Collection<Repository> repositories) {
        this.logger = logger;
        this.localRepository = localRepository;
        this.repositories = new LinkedHashSet<Repository>();
        this.repositories.addAll(repositories.stream().map(Repository::clone).collect(Collectors.toList()));
    }

    public void addRepositories(List<ArtifactRepository> artifactRepositories) throws InvalidRepositoryException {
        for (ArtifactRepository artifactRepository : artifactRepositories) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("    artifactRepository %s %s", artifactRepository.getId(), artifactRepository.getUrl()));
            }
            Repository repository = new Repository();
            repository.setId(artifactRepository.getId());
            repository.setUrl(artifactRepository.getUrl());
            RepositoryPolicy releases = new RepositoryPolicy();
            if (artifactRepository.getReleases() != null) {
                releases.setChecksumPolicy(artifactRepository.getReleases().getChecksumPolicy());
                releases.setEnabled(artifactRepository.getReleases().isEnabled());
                releases.setUpdatePolicy(artifactRepository.getReleases().getUpdatePolicy());
                repository.setReleases(releases);
            }
            RepositoryPolicy snapshots = new RepositoryPolicy();
            if (artifactRepository.getSnapshots() != null) {
                snapshots.setChecksumPolicy(artifactRepository.getSnapshots().getChecksumPolicy());
                snapshots.setEnabled(artifactRepository.getSnapshots().isEnabled());
                snapshots.setUpdatePolicy(artifactRepository.getSnapshots().getUpdatePolicy());
                repository.setSnapshots(snapshots);
            }
            this.addRepository(repository, true);
        }
    }

    public void setLocalRepository(String localRepository) {
        this.localRepository = new File(localRepository);
    }

    public void addRepository(Repository repository) throws InvalidRepositoryException {
        this.addRepository(repository, false);
    }

    public void addRepository(Repository repository, boolean replace) throws InvalidRepositoryException {
        for (Repository existingRepository : this.repositories) {
            if (!existingRepository.getId().equals(repository.getId()) || replace) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("    addRepository [%s] skip [%s]", this, repository));
            }
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info(String.format("    addRepository [%s] add [%s]", this, repository));
        }
        this.repositories.add(repository);
    }

    public ModelResolver newCopy() {
        return new RepositoryModelResolver(this.logger, this.localRepository, this.repositories);
    }

    public ModelSource resolveModel(Dependency dependency) throws UnresolvableModelException {
        return this.resolveModel(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        File pom = this.getLocalFile(groupId, artifactId, version);
        if (!pom.exists()) {
            try {
                this.download(pom);
            }
            catch (Exception e) {
                throw new UnresolvableModelException("Could not download POM", groupId, artifactId, version, (Throwable)e);
            }
        }
        return new FileModelSource(pom);
    }

    public ModelSource resolveModel(Parent parent) throws UnresolvableModelException {
        return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
    }

    private File getLocalFile(String groupId, String artifactId, String version) {
        String[] groupIds;
        File pom = this.localRepository;
        for (String id : groupIds = groupId.split("\\.")) {
            pom = new File(pom, id);
        }
        return new File(new File(new File(pom, artifactId), version), artifactId + "-" + version + ".pom");
    }

    private void download(File localRepoFile) {
        for (Repository repo : this.repositories) {
            String repoUrl = repo.getUrl().endsWith("/") ? repo.getUrl().substring(0, repo.getUrl().length() - 1) : repo.getUrl();
            String filePath = localRepoFile.getAbsolutePath().substring(this.localRepository.getAbsolutePath().length());
            String sourceUrl = repoUrl + filePath;
            Path path = localRepoFile.toPath().normalize();
            Map.Entry<Optional<Integer>, Optional<Exception>> result = DownloadUtils.download(this.logger, sourceUrl, path, Collections.emptyMap(), 3);
            Optional<Integer> status = result.getKey();
            Optional<Exception> error = result.getValue();
            boolean is2xxStatus = status.map(DownloadUtils::is2xxStatus).orElse(Boolean.FALSE);
            if (error.isPresent()) {
                throw new DownloadUtils.DownloadException(error.get());
            }
            if (is2xxStatus) continue;
            throw new DownloadUtils.DownloadException(String.format("url [%s], status [%s]", sourceUrl, status.orElse(null)));
        }
    }
}

