/*
 * Decompiled with CFR 0.152.
 */
package top.infra.maven.extension.internal;

import java.io.File;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.cli.CliRequest;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.internal.aether.DefaultRepositorySystemSessionFactory;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import top.infra.maven.CiOptionContext;
import top.infra.maven.extension.MavenEventAware;
import top.infra.maven.extension.MavenProjectInfo;
import top.infra.maven.extension.MavenProjectInfoFactory;
import top.infra.maven.logging.Logger;
import top.infra.maven.shared.extension.DefaultMavenProjectInfo;
import top.infra.maven.shared.extension.GlobalOption;
import top.infra.maven.shared.logging.LoggerPlexusImpl;
import top.infra.maven.shared.utils.SupportFunction;

@Named
@Singleton
public class MavenProjectInfoEventAware
implements MavenProjectInfoFactory,
MavenEventAware {
    private final Logger logger;
    private final ProjectBuilder projectBuilder;
    private final DefaultRepositorySystemSessionFactory repositorySessionFactory;
    private MavenExecutionRequest mavenExecutionCopied;
    private MavenProjectInfo rootProjectInfo;

    @Inject
    public MavenProjectInfoEventAware(org.codehaus.plexus.logging.Logger logger, ProjectBuilder projectBuilder, DefaultRepositorySystemSessionFactory repositorySessionFactory) {
        this.logger = new LoggerPlexusImpl(logger);
        this.projectBuilder = projectBuilder;
        this.repositorySessionFactory = repositorySessionFactory;
    }

    public int getOrder() {
        return 13;
    }

    public MavenProjectInfo getRootProjectInfo() {
        if (this.rootProjectInfo == null && this.mavenExecutionCopied != null) {
            this.rootProjectInfo = this.resolveRootProject();
        }
        return this.rootProjectInfo;
    }

    private MavenProjectInfo resolveRootProject() {
        this.logger.info(SupportFunction.logStart((Object)this, (String)"resolve", (Object[])new Object[0]));
        MavenProjectInfo projectInfo = this.resolve(this.mavenExecutionCopied.getPom());
        this.logger.info(SupportFunction.logEnd((Object)this, (String)"resolve", (Object)projectInfo, (Object[])new Object[0]));
        return projectInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenProjectInfo resolve(File pomFile) {
        boolean repositorySystemSessionNull = this.createRepositorySystemSessionIfAbsent(this.mavenExecutionCopied);
        ProjectBuildingRequest projectBuildingRequest = this.mavenExecutionCopied.getProjectBuildingRequest();
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("    getMavenProjectInfo pomFile: [%s]", pomFile));
            }
            MavenProjectInfo mavenProjectInfo = DefaultMavenProjectInfo.newProjectInfoByReadPom((Logger)this.logger, (File)pomFile).orElseGet(() -> DefaultMavenProjectInfo.newProjectInfoByBuildProject((Logger)this.logger, (ProjectBuilder)this.projectBuilder, (File)pomFile, (ProjectBuildingRequest)projectBuildingRequest));
            return mavenProjectInfo;
        }
        finally {
            if (repositorySystemSessionNull) {
                projectBuildingRequest.setRepositorySession(null);
            }
        }
    }

    private boolean createRepositorySystemSessionIfAbsent(MavenExecutionRequest request) {
        boolean repositorySystemSessionNull;
        ProjectBuildingRequest projectBuildingRequest = request.getProjectBuildingRequest();
        if (projectBuildingRequest != null) {
            boolean bl = repositorySystemSessionNull = projectBuildingRequest.getRepositorySession() == null;
            if (repositorySystemSessionNull) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(String.format("    repositorySystemSession not found in %s", projectBuildingRequest));
                }
                DefaultRepositorySystemSession repositorySystemSession = this.repositorySessionFactory.newRepositorySession(request);
                projectBuildingRequest.setRepositorySession((RepositorySystemSession)repositorySystemSession);
            }
        } else {
            repositorySystemSessionNull = true;
        }
        return repositorySystemSessionNull;
    }

    public boolean onProjectBuildingRequest() {
        return true;
    }

    public void onProjectBuildingRequest(CliRequest cliRequest, MavenExecutionRequest mavenExecution, ProjectBuildingRequest projectBuilding, CiOptionContext ciOptContext) {
        this.mavenExecutionCopied = DefaultMavenExecutionRequest.copy((MavenExecutionRequest)mavenExecution);
        if (!GlobalOption.FAST.getValue(ciOptContext).map(Boolean::parseBoolean).orElse(Boolean.FALSE).booleanValue()) {
            this.rootProjectInfo = this.resolveRootProject();
        } else {
            this.logger.info("    Lazy resolving project version under fast mode.");
        }
    }
}

