/*
 * Decompiled with CFR 0.152.
 */
package shaded.top.infra.maven.shared;

public enum MavenPhase {
    PRE_CLEAN("pre-clean", "execute processes needed prior to the actual project cleaning"),
    CLEAN("clean", "remove all files generated by the previous build"),
    POST_CLEAN("post-clean", "execute processes needed to finalize the project cleaning"),
    VALIDATE("validate", "validate the project is correct and all necessary information is available."),
    INITIALIZE("initialize", "initialize build state, e.g. set properties or create directories."),
    GENERATE_SOURCES("generate-sources", "generate any source code for inclusion in compilation."),
    PROCESS_SOURCES("process-sources", "process the source code, for example to filter any values."),
    GENERATE_RESOURCES("generate-resources", "generate resources for inclusion in the package."),
    PROCESS_RESOURCES("process-resources", "copy and process the resources into the destination directory, ready for packaging."),
    COMPILE("compile", "compile the source code of the project."),
    PROCESS_CLASSES("process-classes", "post-process the generated files from compilation, for example to do bytecode enhancement on Java classes."),
    GENERATE_TEST_SOURCES("generate-test-sources", "generate any test source code for inclusion in compilation."),
    PROCESS_TEST_SOURCES("process-test-sources", "process the test source code, for example to filter any values."),
    GENERATE_TEST_RESOURCES("generate-test-resources", "create resources for testing."),
    PROCESS_TEST_RESOURCES("process-test-resources", "copy and process the resources into the test destination directory."),
    TEST_COMPILE("test-compile", "compile the test source code into the test destination directory"),
    PROCESS_TEST_CLASSES("process-test-classes", "post-process the generated files from test compilation, for example to do bytecode enhancement on Java classes. For Maven 2.0.5 and above."),
    TEST("test", "run tests using a suitable unit testing framework. These tests should not require the code be packaged or deployed."),
    PREPARE_PACKAGE("prepare-package", "perform any operations necessary to prepare a package before the actual packaging. This often results in an unpacked, processed version of the package. (Maven 2.1 and above)"),
    PACKAGE("package", "take the compiled code and package it in its distributable format, such as a JAR."),
    PRE_INTEGRATION_TEST("pre-integration-test", "perform actions required before integration tests are executed. This may involve things such as setting up the required environment."),
    INTEGRATION_TEST("integration-test", "process and deploy the package if necessary into an environment where integration tests can be run."),
    POST_INTEGRATION_TEST("post-integration-test", "perform actions required after integration tests have been executed. This may including cleaning up the environment."),
    VERIFY("verify", "run any checks to verify the package is valid and meets quality criteria."),
    INSTALL("install", "install the package into the local repository, for use as a dependency in other projects locally."),
    DEPLOY("deploy", "done in an integration or release environment, copies the final package to the remote repository for sharing with other developers and projects."),
    PRE_SITE("pre-site", "execute processes needed prior to the actual project site generation"),
    SITE("site", "generate the project's site documentation"),
    POST_SITE("post-site", "execute processes needed to finalize the site generation, and to prepare for site deployment"),
    SITE_DEPLOY("site-deploy", "deploy the generated site documentation to the specified web server");

    private String phase;
    private String description;

    private MavenPhase(String phase, String description) {
        this.phase = phase;
        this.description = description;
    }

    public String getPhase() {
        return this.phase;
    }
}

