/*
 * Decompiled with CFR 0.152.
 */
package shaded.top.infra.maven.shared.extension.activator.model;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.codehaus.plexus.logging.Logger;
import top.infra.maven.extension.activator.model.ActivatorModelResolver;

public abstract class AbstractActivatorModelResolver
implements ActivatorModelResolver {
    protected final Logger logger;
    private final ModelBuilder modelBuilder;
    private final Map<String, Model> profileMemento;
    private final boolean verbose;

    protected AbstractActivatorModelResolver(Logger logger, ModelBuilder modelBuilder) {
        this.logger = logger;
        this.modelBuilder = modelBuilder;
        this.profileMemento = new LinkedHashMap<String, Model>();
        this.verbose = logger.isDebugEnabled();
    }

    @Override
    public Optional<Model> resolveModel(Profile profile, ProfileActivationContext context) {
        boolean doResolve;
        Model modelFound;
        File pomFile = this.projectPOM(context);
        if ("source".equals(profile.getSource())) {
            this.registerMemento(profile, pomFile, null);
            if (this.verbose) {
                this.logger.debug(String.format("    profile [%s] source is 'source'.", profile));
            }
            return Optional.empty();
        }
        if (pomFile == null) {
            this.registerMemento(profile, null, null);
            if (this.verbose) {
                this.logger.debug(String.format("    pomFile not found for profile [%s].", profile));
            }
            return Optional.empty();
        }
        if (this.hasMemento(profile, pomFile)) {
            modelFound = this.getMemento(profile, pomFile);
            doResolve = false;
            if (this.verbose) {
                this.logger.debug(String.format("    resolveModel [%s] for profile [%s]. false", pomFile.getPath(), profile));
            }
        } else {
            modelFound = null;
            doResolve = true;
            if (this.verbose) {
                this.logger.debug(String.format("    resolveModel [%s] for profile [%s]. true", pomFile.getPath(), profile));
            }
        }
        if (!this.hasMemento(profile, pomFile)) {
            this.registerMemento(profile, pomFile, null);
        }
        if (doResolve) {
            try {
                ModelBuildingRequest buildingRequest = this.modelBuildingRequest(context, pomFile);
                ModelBuildingResult buildingResult = this.modelBuilder.build(buildingRequest);
                return Optional.of(this.registerMemento(profile, pomFile, buildingResult.getEffectiveModel()));
            }
            catch (Exception error) {
                this.logger.error(String.format("    resolveModel [%s] model for profile [%s] error. %s", pomFile.getPath(), profile, error.getMessage()), (Throwable)error);
                return Optional.empty();
            }
        }
        return Optional.ofNullable(modelFound);
    }

    protected abstract ModelBuildingRequest modelBuildingRequest(ProfileActivationContext var1, File var2);

    private File projectPOM(ProfileActivationContext context) {
        File basedir = context.getProjectDirectory();
        if (basedir == null) {
            return null;
        }
        File pomFile = new File(basedir, "pom.xml");
        if (pomFile.exists()) {
            return pomFile.getAbsoluteFile();
        }
        this.logger.warn(String.format("    pomFile not exists [%s]", pomFile.getPath()));
        return null;
    }

    private boolean hasMemento(Profile profile, File pomFile) {
        String key = AbstractActivatorModelResolver.mementoKey(profile, pomFile);
        boolean result = pomFile != null && this.profileMemento.containsKey(key);
        return result;
    }

    private Model getMemento(Profile profile, File pomFile) {
        String key = AbstractActivatorModelResolver.mementoKey(profile, pomFile);
        return this.hasMemento(profile, pomFile) ? this.profileMemento.get(key) : null;
    }

    private Model registerMemento(Profile profile, File pomFile, Model model) {
        if (pomFile != null) {
            String key = AbstractActivatorModelResolver.mementoKey(profile, pomFile);
            this.profileMemento.put(key, model);
        }
        return model;
    }

    private static String mementoKey(Profile profile, File pomFile) {
        String pom = pomFile != null ? pomFile.getPath() : "";
        return String.format("%s@%s", profile, pom);
    }
}

