/*
 * Decompiled with CFR 0.152.
 */
package shaded.top.infra.maven.shared.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import shaded.top.infra.maven.shared.exception.RuntimeIOException;

public class FileUtils {
    public static boolean isSameFile(Path p1, Path p2) {
        try {
            return Files.isSameFile(p1, p2);
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static void copyFile(String from, String to) {
        try {
            Files.copy(Paths.get(from, new String[0]), Paths.get(to, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
    }

    public static String createDirectories(String pathname) {
        Path path = Paths.get(pathname, new String[0]);
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException ex) {
            if (path.toFile().isFile()) {
                throw new RuntimeIOException(String.format("Error create directory '%s'. %s", pathname, ex.getMessage()), ex);
            }
        }
        catch (IOException ex) {
            throw new RuntimeIOException(String.format("Error create directory '%s'. %s", pathname, ex.getMessage()), ex);
        }
        return pathname;
    }

    public static String pathname(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ex) {
            return file.getAbsolutePath();
        }
    }

    public static Optional<String> readFile(Path path, Charset encoding) {
        try {
            return Optional.of(new String(Files.readAllBytes(path), encoding));
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
    }

    public static boolean writeFile(Path path, byte[] bytes, StandardOpenOption ... options) {
        try {
            Files.write(path, bytes, (OpenOption[])options);
            return true;
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
    }
}

