/*
 * Decompiled with CFR 0.152.
 */
package shaded.top.infra.maven.shared;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import shaded.top.infra.maven.shared.utils.PropertiesUtils;
import top.infra.maven.CiOption;
import top.infra.maven.CiOptionContext;

public class DefaultCiOptionContext
implements CiOptionContext {
    private final Properties systemProperties;
    private final Properties userProperties;

    public DefaultCiOptionContext(Properties systemProperties, Properties userProperties) {
        this.systemProperties = systemProperties;
        this.userProperties = userProperties;
    }

    @Override
    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public Properties getUserProperties() {
        return this.userProperties;
    }

    @Override
    public Properties setCiOptPropertiesInto(Collection<List<CiOption>> optionGroups, Properties ... targetProperties) {
        Properties properties = new Properties();
        optionGroups.stream().flatMap(group -> group.stream().sorted()).forEach(ciOption -> {
            if (!ciOption.name().equals(ciOption.name(ciOption.getPropertyName()))) {
                throw new IllegalArgumentException(String.format("invalid property name [%s] for enum name [%s]", ciOption.name(), ciOption.getPropertyName()));
            }
            ciOption.setProperties(this, properties);
        });
        for (Properties target : targetProperties) {
            PropertiesUtils.merge(properties, target);
        }
        return properties;
    }
}

