/*
 * Decompiled with CFR 0.152.
 */
package shaded.top.infra.maven.shared.cienv;

import java.util.Optional;
import java.util.Properties;
import shaded.top.infra.maven.shared.utils.SupportFunction;

public class AppveyorVariables {
    public static final String APPVEYOR_PULL_REQUEST_HEAD_REPO_NAME = "env.APPVEYOR_PULL_REQUEST_HEAD_REPO_NAME";
    private static final String APPVEYOR_REPO_BRANCH = "env.APPVEYOR_REPO_BRANCH";
    private static final String APPVEYOR_REPO_NAME = "env.APPVEYOR_REPO_NAME";
    private static final String APPVEYOR_REPO_TAG = "env.APPVEYOR_REPO_TAG";
    private static final String APPVEYOR_REPO_TAG_NAME = "env.APPVEYOR_REPO_TAG_NAME";
    private final Properties systemProperties;

    public AppveyorVariables(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public boolean isPullRequest() {
        return this.pullRequestHeadRepoName().map(SupportFunction::notEmpty).orElse(Boolean.FALSE);
    }

    public Optional<String> pullRequestHeadRepoName() {
        return this.getEnvironmentVariable(APPVEYOR_PULL_REQUEST_HEAD_REPO_NAME);
    }

    private Optional<String> getEnvironmentVariable(String name) {
        return Optional.ofNullable(this.systemProperties.getProperty(name, null));
    }

    public Optional<String> refName() {
        return this.repoTagName() ? this.repoTag() : this.repoBranch();
    }

    private Optional<String> repoBranch() {
        return this.getEnvironmentVariable(APPVEYOR_REPO_BRANCH);
    }

    private Optional<String> repoTag() {
        return this.getEnvironmentVariable(APPVEYOR_REPO_TAG);
    }

    public boolean repoTagName() {
        return this.getEnvironmentVariable(APPVEYOR_REPO_TAG_NAME).map(Boolean::parseBoolean).orElse(Boolean.FALSE);
    }

    public String toString() {
        return String.format("appveyor variables: APPVEYOR_REPO_TAG_NAME: [%s], APPVEYOR_REPO_TAG: [%s], APPVEYOR_REPO_NAME: [%s], APPVEYOR_PULL_REQUEST_HEAD_REPO_NAME: [%s]", this.getEnvironmentVariable(APPVEYOR_REPO_TAG_NAME).orElse("N/A"), this.repoTag().orElse("N/A"), this.repoSlug().orElse("N/A"), this.pullRequestHeadRepoName().orElse("N/A"));
    }

    public Optional<String> repoSlug() {
        return this.repoName();
    }

    private Optional<String> repoName() {
        return this.getEnvironmentVariable(APPVEYOR_REPO_NAME);
    }
}

