/*
 * Decompiled with CFR 0.152.
 */
package shaded.top.infra.maven.shared.cienv;

import java.util.Optional;
import java.util.Properties;

public class TravisCiVariables {
    private final Properties systemProperties;

    public TravisCiVariables(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public boolean isPullRequestEvent() {
        return "pull_request".equals(this.eventType().orElse(""));
    }

    public Optional<String> eventType() {
        return this.getEnvironmentVariable("env.TRAVIS_EVENT_TYPE");
    }

    private Optional<String> getEnvironmentVariable(String name) {
        return Optional.ofNullable(this.systemProperties.getProperty(name, null));
    }

    public String toString() {
        return String.format("travis-ci variables: TRAVIS_BRANCH: [%s], TRAVIS_EVENT_TYPE: [%s], TRAVIS_REPO_SLUG: [%s], TRAVIS_PULL_REQUEST: [%s]", this.branch().orElse("N/A"), this.eventType().orElse("N/A"), this.repoSlug().orElse("N/A"), this.pullRequest().orElse("N/A"));
    }

    public Optional<String> branch() {
        return this.getEnvironmentVariable("env.TRAVIS_BRANCH");
    }

    public Optional<String> pullRequest() {
        return this.getEnvironmentVariable("env.TRAVIS_PULL_REQUEST");
    }

    public Optional<String> repoSlug() {
        return this.getEnvironmentVariable("env.TRAVIS_REPO_SLUG");
    }
}

