/*
 * Decompiled with CFR 0.152.
 */
package shaded.top.infra.maven.shared.extension;

import java.util.Optional;
import java.util.Properties;
import java.util.function.BiFunction;
import top.infra.maven.CiOption;
import top.infra.maven.CiOptionContext;

public enum GlobalOption implements CiOption
{
    FAST("fast"),
    INFRASTRUCTURE("infrastructure");

    private final String defaultValue;
    private final String propertyName;

    private GlobalOption(String propertyName) {
        this(propertyName, null);
    }

    private GlobalOption(String propertyName, String defaultValue) {
        this.defaultValue = defaultValue;
        this.propertyName = propertyName;
    }

    public static Optional<String> getInfrastructureSpecificValue(CiOption ciOption, CiOptionContext context) {
        return INFRASTRUCTURE.getValue(context).map(infra -> {
            String propName = infra + "." + ciOption.getPropertyName();
            String systemPropName = ciOption.systemPropertyName(propName);
            return Optional.ofNullable(context.getUserProperties().getProperty(propName)).orElseGet(() -> context.getSystemProperties().getProperty(systemPropName));
        });
    }

    public static Optional<String> setInfrastructureSpecificValue(CiOption ciOption, BiFunction<CiOptionContext, Properties, Optional<String>> superSetProperties, CiOptionContext context, Properties properties) {
        Optional<String> result = superSetProperties.apply(context, properties);
        result.ifPresent(value -> INFRASTRUCTURE.getValue(context).ifPresent(infra -> properties.setProperty(infra + "." + ciOption.getPropertyName(), (String)value)));
        return result;
    }

    @Override
    public Optional<String> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue);
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }
}

