/*
 * Decompiled with CFR 0.152.
 */
package shaded.top.infra.maven.shared.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import shaded.top.infra.maven.shared.utils.SupportFunction;

public abstract class SystemUtils {
    private SystemUtils() {
    }

    public static Map.Entry<Integer, String> exec(String command) {
        try {
            Process proc = Runtime.getRuntime().exec(command);
            return SystemUtils.execResult(proc);
        }
        catch (IOException ex) {
            return SupportFunction.newTuple(-1, "");
        }
    }

    private static Map.Entry<Integer, String> execResult(Process proc) {
        try {
            String result = new BufferedReader(new InputStreamReader(proc.getInputStream())).lines().collect(Collectors.joining("\n"));
            return SupportFunction.newTuple(proc.waitFor(), result);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return SupportFunction.newTuple(-1, "");
        }
    }

    public static Map.Entry<Integer, String> exec(Map<String, String> environment, String stdIn, List<String> command) {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        if (environment != null) {
            processBuilder.environment().putAll(environment);
        }
        try {
            Process proc = processBuilder.start();
            if (stdIn != null) {
                try (PrintWriter writer = new PrintWriter(proc.getOutputStream());){
                    writer.println(stdIn);
                    writer.flush();
                }
            }
            return SystemUtils.execResult(proc);
        }
        catch (IOException ex) {
            return SupportFunction.newTuple(-1, "");
        }
    }

    public static boolean existsInPath(String exec) {
        return Stream.of(System.getenv("PATH").split(Pattern.quote(File.pathSeparator))).map(x$0 -> Paths.get(x$0, new String[0])).anyMatch(path -> path.resolve(exec).toFile().exists());
    }

    public static String os() {
        String osName = System.getProperty("os.name", "generic").toLowerCase();
        String result = osName.contains("mac") ? "darwin" : (osName.contains("win") ? "windows" : (osName.contains("nix") || osName.contains("nux") || osName.contains("aix") ? "unix" : "generic"));
        return result;
    }

    public static boolean isWindows() {
        return "windows".equalsIgnoreCase(SystemUtils.os());
    }

    public static String systemJavaIoTmp() {
        return System.getProperty("java.io.tmpdir");
    }

    public static Optional<Integer> systemJavaVersion() {
        String systemJavaVersion = System.getProperty("java.version");
        return SystemUtils.parseJavaVersion(systemJavaVersion);
    }

    public static Optional<Integer> parseJavaVersion(String javaVersion) {
        Optional<Integer> result = javaVersion.matches("1.\\d+\\.?.*") ? Optional.of(Integer.parseInt(javaVersion.split("\\.")[1])) : (javaVersion.matches("\\d+\\.?.*") ? Optional.of(Integer.parseInt(javaVersion.split("\\.")[0])) : Optional.empty());
        return result;
    }

    public static String systemUserHome() {
        return System.getProperty("user.home", SystemUtils.systemUserDir());
    }

    public static String systemUserDir() {
        return System.getProperty("user.dir", Paths.get(".", new String[0]).normalize().toString());
    }
}

