/*
 * Decompiled with CFR 0.152.
 */
package shaded.top.infra.maven.shared.extension;

import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shaded.top.infra.maven.shared.cienv.AppveyorVariables;
import shaded.top.infra.maven.shared.cienv.GitlabCiVariables;
import shaded.top.infra.maven.shared.cienv.TravisCiVariables;
import top.infra.maven.CiOption;
import top.infra.maven.CiOptionContext;
import top.infra.maven.logging.Logger;

public enum VcsProperties implements CiOption
{
    GIT_COMMIT_ID("git.commit.id"),
    GIT_REF_NAME("git.ref.name"){

        @Override
        public Optional<String> calculateValue(CiOptionContext context) {
            Optional<String> appveyorRefName = new AppveyorVariables(context.getSystemProperties()).refName();
            Optional<String> gitlabCiRefName = new GitlabCiVariables(context.getSystemProperties()).refName();
            Optional<String> travisBranch = new TravisCiVariables(context.getSystemProperties()).branch();
            Optional<String> result = appveyorRefName.isPresent() ? appveyorRefName : (gitlabCiRefName.isPresent() ? gitlabCiRefName : travisBranch);
            return result;
        }
    }
    ,
    GIT_REMOTE_ORIGIN_URL("git.remote.origin.url");

    static final Pattern PATTERN_GIT_REPO_SLUG;
    private final String defaultValue;
    private final String propertyName;

    private VcsProperties(String propertyName) {
        this(propertyName, (String)null);
    }

    private VcsProperties(String propertyName, String defaultValue) {
        this.defaultValue = defaultValue;
        this.propertyName = propertyName;
    }

    public static void info(Logger logger, CiOptionContext context) {
        Properties systemProperties = context.getSystemProperties();
        logger.info(String.format("    AppVeyor variables: %s", new AppveyorVariables(systemProperties)));
        logger.info(String.format("    GitLabCI variables: %s", new GitlabCiVariables(systemProperties)));
        logger.info(String.format("    TravisCI variables: %s", new TravisCiVariables(systemProperties)));
    }

    public static boolean isSnapshotRef(String gitRef) {
        return gitRef != null && !gitRef.isEmpty() && ("develop".equals(gitRef) || gitRef.startsWith("feature/"));
    }

    public static boolean isReleaseRef(String gitRef) {
        return gitRef != null && !gitRef.isEmpty() && (gitRef.startsWith("hotfix/") || gitRef.startsWith("release/") || gitRef.startsWith("support/"));
    }

    public static boolean isPullRequest(CiOptionContext ciOptionContext) {
        Properties systemProperties = ciOptionContext.getSystemProperties();
        AppveyorVariables appveyor = new AppveyorVariables(systemProperties);
        TravisCiVariables travisCi = new TravisCiVariables(systemProperties);
        return appveyor.isPullRequest() || travisCi.isPullRequestEvent();
    }

    public static Optional<String> gitRepoSlug(CiOptionContext ciOptionContext) {
        Optional<String> gitRemoteOriginUrl;
        Properties systemProperties = ciOptionContext.getSystemProperties();
        Optional<String> appveyorRepoSlug = new AppveyorVariables(systemProperties).repoSlug();
        Optional<String> gitlabCiRepoSlug = new GitlabCiVariables(systemProperties).repoSlug();
        Optional<String> travisRepoSlug = new TravisCiVariables(systemProperties).repoSlug();
        Optional<String> result = appveyorRepoSlug.isPresent() ? appveyorRepoSlug : (gitlabCiRepoSlug.isPresent() ? gitlabCiRepoSlug : (travisRepoSlug.isPresent() ? travisRepoSlug : ((gitRemoteOriginUrl = GIT_REMOTE_ORIGIN_URL.getValue(ciOptionContext)).isPresent() ? VcsProperties.gitRepoSlugFromUrl(gitRemoteOriginUrl.get()) : Optional.empty())));
        return result;
    }

    static Optional<String> gitRepoSlugFromUrl(String url) {
        Matcher matcher = PATTERN_GIT_REPO_SLUG.matcher(url);
        Optional<String> result = matcher.matches() ? Optional.ofNullable(matcher.group(1)) : Optional.empty();
        return result;
    }

    @Override
    public Optional<String> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue);
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    static {
        PATTERN_GIT_REPO_SLUG = Pattern.compile(".*[:/]([^/]+(/[^/.]+))(\\.git)?");
    }
}

